<?php
    $investment_data = getJsonData('investmentapi');
?>
<h2 class="titleHead"><span>Investment Opportunities</span></h2>
<?php
$inv_types = array_keys(get_object_vars($investment_data));
?>
<ul class="nav nav-tabs" id="myTab" role="tablist">
    <?php if(!empty($inv_types)): ?>
    <?php $__currentLoopData = $inv_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <li class="nav-item">
        <a class="nav-link <?php if($loop->first): ?> active <?php endif; ?>" id="<?php echo e(str_replace(" ", "_", $type)); ?>-tab" data-toggle="tab" href="#<?php echo e(str_replace(" ", "_", $type)); ?>" role="tab" aria-controls="<?php echo e(str_replace(" ", "_", $type)); ?>" aria-selected="true"><?php echo e($type); ?></a>
    </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
</ul>
<div class="tab-content" id="myTabContent">
    <?php if(!empty($investment_data)): ?>
    <?php $count = 0; ?>
    <?php $__currentLoopData = $investment_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="tab-pane fade show <?php if($loop->first): ?> active <?php endif; ?>" id="<?php echo e(str_replace(" ", "_", $item[$count]->investment_type)); ?>" role="tabpanel" aria-labelledby="<?php echo e(str_replace(" ", "_", $item[$count]->investment_type)); ?>-tab">
        <table class="table table-hover table-striped">
            <thead>
                <tr>
                    <th>S.N.</th>
                    <th>Symbol</th>
                    <th>Company</th>
                    <?php if($item[$count]->investment_type == 'Right Share'): ?>
                    <th>Ratio</th>
                    <?php endif; ?>
                    <th>Units</th>
                    <th>Price</th>
                    <th>Opening Date</th>
                    <th>Closing Date</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php if(!empty($item)): ?>
                <?php $__currentLoopData = $item; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $inv_type_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <?php
                    $status_data =getInvestmentStatus($inv_type_data->opening_date, $inv_type_data->closing_date);
                    $status_title = $status_data['title'];
                    $status_style = $status_data['style'];
                    ?>
                    <td><?php echo e($k+1); ?></td>
                    <td><?php echo e($inv_type_data->symbol); ?></td>
                    <td><?php echo e($inv_type_data->companyname); ?></td>
                    <?php if($item[$count]->investment_type == 'Right Share'): ?>
                    <td><?php echo e($inv_type_data->ratio); ?></td>
                    <?php endif; ?>
                    <td><?php echo e($inv_type_data->total_units); ?></td>
                    <td><?php echo e($inv_type_data->price); ?></td>
                    <td><?php echo e(($inv_type_data->opening_date) ? Carbon\Carbon::parse($inv_type_data->opening_date)->format('Y-m-d') : 'Coming Soon'); ?></td>
                    <td><?php echo e(($inv_type_data->closing_date) ? Carbon\Carbon::parse($inv_type_data->closing_date)->format('Y-m-d') : 'Coming Soon'); ?></td>
                    <td class="text-white <?php echo e($status_style); ?>"><?php echo e($status_title); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <? $count++ ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
</div>
