
<?php $__env->startSection('content'); ?>
<!-- Default box -->
<div class="col-md-8 col-lg-8 col-sm-12 col-xs-12">
    <div class="col-md-10 box">
        <div class="box-header with-border">
            <h3 class="box-title"><?php echo e($page_header); ?></h3>
        </div>
        <div class="box-body">
            <div class="table-responsive">
                <table class="table table-hover table-condensed dataTable">
                    <thead class="bg-primary">
                        <tr>
                            <th>S.No</th>
                            <th>Broker Branch</th>
                            <th>Title</th>
                            <th>Order</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1; ?>
                        <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($count++); ?></td>
                            <td><?php echo e($item->branch->broker_name); ?></td>
                            <td><?php echo e($item->sequence_no); ?></td>
                            <td><?php echo e($item->title); ?></td>
                            <td class="center-align">
                                <?php if($item->status == '1'): ?>
                                <?php echo ACTIVE_STATUS; ?>

                                <?php else: ?>
                                <?php echo INACTIVE_STATUS; ?>

                                <?php endif; ?>
                            </td>
                            <td width="100px" class="center-align">
                                <a href="<?php echo e(route('department.edit', $item->id)); ?>"><?php echo EDIT_ICON; ?> </a>&nbsp;|&nbsp;
                                <a href="<?php echo e(route('department.delete', $item->id)); ?>" class="resetbtn"><?php echo DELETE_ICON; ?></a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($list->links()); ?>

            </div>
        </div>
    </div>
</div>
<div class="col-md-4 col-lg-4 col-sm-12 col-xs-12">
    <div class="col-md-10 box">
        <div class="box-header with-border">
            <h3 class="box-title">Edit Department</h3>
            <span class="pull-right"><a href="<?php echo e(route('department.index')); ?>" class="btn btn-warning"><i class="fa fa-plus" aria-hidden="true"></i>&nbsp; Add New </a></span>
        </div>
        <div class="box-body">
            <form method="POST" action="<?php echo e(route('department.update', $record->id)); ?>">
                <?php echo e(csrf_field()); ?>

                <?php echo e(method_field('PATCH')); ?>

                <div class="form-group">
                    <label for="broekr">Broker Branch <span class='text-danger'>*</span> </label>
                    <select name="branch_id" id="branch_id" class="form-control">
                        <option value="">Select Broker Branch</option>
                        <?php if(!empty($brokerlist)): ?>
                        <?php $__currentLoopData = $brokerlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kl => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($item->id); ?>" <?php if($record->branch_id == $item->id): ?> <?php echo e('selected'); ?> <?php endif; ?>><?php echo e($item->broker_name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                    <?php if($errors->has('branch_id')): ?>
                    <span class="help-block">
                        <strong><?php echo e($errors->first('branch_id')); ?></strong>
                    </span>
                    <?php endif; ?>
                </div>
                <div class="form-group">
                    <label for="title">Title <span class='text-danger'>*</span></label>
                    <input type="text" class="form-control" id="title" name="title" value="<?php echo e($record->title); ?>">
                    <?php if($errors->has('title')): ?>
                    <span class="help-block">
                        <strong><?php echo e($errors->first('title')); ?></strong>
                    </span>
                    <?php endif; ?>
                </div>
                <div class="form-group">
                    <label for="sequence_no">Sequence Number <span class='text-danger'>*</span></label>
                    <input type="text" class="form-control" id="sequence_no" name="sequence_no" value="<?php echo e($record->sequence_no); ?>">
                </div>
                <div class="form-group">
                    <label for="status">Status</label>
                    <select name="status" id="statusid" class="form-control">
                        <option value="1" <?= isset($record->status) && ($record->status == '1')? 'selected' : '' ?> ><?php echo PUBLISH; ?></option>
                        <option value="0" <?= isset($record->status) && ($record->status == '0')? 'selected' : '' ?> ><?php echo UNPUBLISH; ?></option>
                    </select>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-success">Update</button>
                    <button type="reset" class="btn btn-danger resetbtn">Reset</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin/app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>