<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-8 col-lg-8 col-sm-12 col-xs-12">
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title"><?php echo e($page_header); ?></h3>
            </div>
            <div class="box-body">
                <div class="table-responsive">
                    <table class="table table-hover table-condensed dataTable">
                        <thead class="bg-primary">
                            <tr>
                                <th>S.No</th>
                                <th>Broker Name</th>
                                <th>Sequence Number</th>
                                <th>Status</th>
                                <th class="text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $count = 1; ?>
                            <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($count++); ?></td>
                                <td><?php echo e($item->broker_name); ?></td>
                                <td><?php echo e($item->sequence_no); ?></td>
                                <td class="text-center">
                                    <?php if($item->status == '1'): ?>
                                    <?php echo ACTIVE_STATUS; ?>

                                    <?php else: ?>
                                    <?php echo INACTIVE_STATUS; ?>

                                    <?php endif; ?>
                                </td>
                                <td width="100px" class="text-center">
                                    <a href="<?php echo e(route($link.'.edit', $item->id)); ?>"><?php echo EDIT_ICON; ?> </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php echo e($list->links()); ?>

                    <p><b>Note:</b> To Update Detail of Main Branch, Go To <a href="<?php echo e(route('setting')); ?>">Site Management Tab</a></p>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4 col-lg-4 col-sm-12 col-xs-12">
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">Add Broker</h3>
            </div>
            <div class="box-body">
                <form method="POST" action="<?php echo e(route($link.'.store')); ?>">
                    <?php echo e(csrf_field()); ?>

                    <div class="form-group">
                        <label for="title">Broker Name <span class='text-danger'>*</span></label>
                        <input type="text" class="form-control" id="broker_name" name="broker_name" value="<?php echo e(old('broker_name')); ?>">
                        <?php if($errors->has('broker_name')): ?>
                        <span class="help-block">
                            <strong><?php echo e($errors->first('broker_name')); ?></strong>
                        </span>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="title">Email Address</label>
                        <input type="text" class="form-control" id="email_address" name="email_address" value="<?php echo e(old('email_address')); ?>">
                        <?php if($errors->has('email_address')): ?>
                        <span class="help-block">
                            <strong><?php echo e($errors->first('email_address')); ?></strong>
                        </span>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="title">Address</label>
                        <input type="text" class="form-control" id="address" name="address" value="<?php echo e(old('address')); ?>">
                        <?php if($errors->has('address')): ?>
                        <span class="help-block">
                            <strong><?php echo e($errors->first('address')); ?></strong>
                        </span>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="title">Mobile No. </label>
                        <input type="text" class="form-control" id="mobile_no" name="mobile_no" value="<?php echo e(old('mobile_no')); ?>">
                        <?php if($errors->has('mobile_no')): ?>
                        <span class="help-block">
                            <strong><?php echo e($errors->first('mobile_no')); ?></strong>
                        </span>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="title">Phone No </label>
                        <input type="text" class="form-control" id="phone_no" name="phone_no" value="<?php echo e(old('phone_no')); ?>">
                        <?php if($errors->has('phone_no')): ?>
                        <span class="help-block">
                            <strong><?php echo e($errors->first('phone_no')); ?></strong>
                        </span>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="title">Fax No </label>
                        <input type="text" class="form-control" id="fax_no" name="fax_no" value="<?php echo e(old('fax_no')); ?>">
                        <?php if($errors->has('fax_no')): ?>
                        <span class="help-block">
                            <strong><?php echo e($errors->first('fax_no')); ?></strong>
                        </span>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="title">Other Data Name</label>
                        <input type="text" class="form-control" id="other_data_name" name="other_data_name" value="<?php echo e(old('other_data_name')); ?>">
                        <?php if($errors->has('other_data_name')): ?>
                        <span class="help-block">
                            <strong><?php echo e($errors->first('other_data_name')); ?></strong>
                        </span>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="title">Other Data Value</label>
                        <input type="text" class="form-control" id="other_data_value" name="other_data_value" value="<?php echo e(old('other_data_value')); ?>">
                        <?php if($errors->has('other_data_value')): ?>
                        <span class="help-block">
                            <strong><?php echo e($errors->first('other_data_value')); ?></strong>
                        </span>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="title">Office Hour</label>
                        <input type="text" class="form-control" id="office_hour" name="office_hour" value="<?php echo e(old('office_hour')); ?>">
                        <?php if($errors->has('office_hour')): ?>
                        <span class="help-block">
                            <strong><?php echo e($errors->first('office_hour')); ?></strong>
                        </span>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="title">Map</label>
                        <input type="text" class="form-control" id="map" name="map" value="<?php echo e(old('map')); ?>">
                        <?php if($errors->has('map')): ?>
                        <span class="help-block">
                            <strong><?php echo e($errors->first('map')); ?></strong>
                        </span>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select name="status" id="statusid" class="form-control">
                            <option value="1"><?php echo PUBLISH; ?></option>
                            <option value="0"><?php echo UNPUBLISH; ?></option>
                        </select>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-success">Submit</button>
                        <button type="reset" class="btn btn-danger">Reset</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin/app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>