<?php
    $jsondata = getJsonData('sharepriceapi');

    $gainers = $jsondata->list;
    usort($gainers, function($a, $b)
                        {
                            if ($a->per_change == $b->per_change) {
                                return 0;
                            }
                            // sort by highest to lowest
                            return ($a->per_change > $b->per_change) ? -1 : 1;
                        });
    $losers = $jsondata->list;
    usort($losers, function($a, $b)
                        {
                            if ($a->per_change == $b->per_change) {
                                return 0;
                            }
                            // sort by lowest to highest
                            return ($a->per_change < $b->per_change) ? -1 : 1;
                        });
    //pe($gainers);
?>
<h2 class="titleHead"><span>Nepse Market</span></h2>
<ul class="nav nav-tabs" id="myTab" role="tablist">
    <li class="nav-item">
        <a class="nav-link active" id="topgainer-tab" data-toggle="tab" href="#topgainer" role="tab" aria-controls="topgainer" aria-selected="true">Top Gainer</a>
    </li>
    <li class="nav-item">
        <a class="nav-link" id="toploser-tab" data-toggle="tab" href="#toploser" role="tab" aria-controls="toploser" aria-selected="false">Top Loser</a>
    </li>
    
</ul>
<div class="tab-content" id="myTabContent">
    <div class="tab-pane fade show active" id="topgainer" role="tabpanel" aria-labelledby="topgainer-tab">
        <table class="table table-hover table-striped">
            <thead>
                <tr>
                    <th>Index</th>
                    <th>Current</th>
                    <th>Pt Change</th>
                    <th>% Change</th>
                </tr>
            </thead>
            <tbody>
                <?php if(!empty($gainers)): ?>
                <?php for($i = 0; $i < 5; $i++): ?>
                <tr>
                    <td title="<?php echo e($gainers[$i]->companyname); ?>"><?php echo e($gainers[$i]->symbol); ?></td>
                    <td><?php echo e($gainers[$i]->close); ?></td>
                    <td><?php echo e(number_format($gainers[$i]->point_change, 2)); ?></td>
                    <td><?php echo e(number_format($gainers[$i]->per_change, 2)); ?></td>
                </tr>
                <?php endfor; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <div class="tab-pane fade" id="toploser" role="tabpanel" aria-labelledby="toploser-tab">
        <table class="table table-hover table-striped">
            <thead>
                <tr>
                    <th>Index</th>
                    <th>Current</th>
                    <th>Pt Change</th>
                    <th>% Change</th>
                </tr>
            </thead>
            <tbody>
                <?php if(!empty($losers)): ?>
                <?php for($i = 0; $i < 5; $i++): ?>
                <tr>
                    <td title="<?php echo e($losers[$i]->companyname); ?>"><?php echo e($losers[$i]->symbol); ?></td>
                    <td><?php echo e($losers[$i]->close); ?></td>
                    <td><?php echo e(number_format($losers[$i]->point_change, 2)); ?></td>
                    <td><?php echo e(number_format($losers[$i]->per_change, 2)); ?></td>
                </tr>
                <?php endfor; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <div class="tab-pane fade" id="topturnover" role="tabpanel" aria-labelledby="topturnover-tab">
        <table class="table table-hover table-striped">
            <thead>
                <tr>
                    <th>Index</th>
                    <th>Current</th>
                    <th>Pt Change</th>
                    <th>% Change</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Turnover</td>
                    <td>123123</td>
                    <td>123</td>
                    <td>12.21</td>
                </tr>
                <tr>
                    <td>Turnover</td>
                    <td>123123</td>
                    <td>123</td>
                    <td>12.21</td>
                </tr>
            </tr>
        </tbody>
    </table>
</div>