<?php $__env->startSection('content'); ?>
<div class="box">
    <div class="box-header with-border">
      <h3 class="box-title"><?php echo e($page_header); ?></h3>
      <span class="pull-right"><a href="<?php echo e(route($link.'.index')); ?>" class="btn btn-warning"><i class="fa fa-chevron-left" aria-hidden="true"></i>&nbsp;  View List </a></span>
    </div>
    <div class="box-body">
        <form class="" method="POST" action="<?php echo e(route($link.'.update', $record->id)); ?> ">
            <?php echo e(csrf_field()); ?>

            <?php echo e(method_field('PATCH')); ?>

            <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                <div class="form-group">
                    <label class="control-label" for="title">Title <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="title" name="title" value="<?php echo e($record->title); ?>" >
                    <?php if($errors->has('title')): ?>
                        <span class="help-block">
                            <strong><?php echo e($errors->first('title')); ?></strong>
                        </span>
                    <?php endif; ?>
                </div>
                <div class="form-group">
                    <label class="control-label" for="title">Link </label>
                    <input type="text" class="form-control" id="link" name="link" value="<?php echo e($record->link); ?>" >
                </div>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">                
                <div class="form-group">
                   <label class="control-label">Featured Image <span class="text-danger">*</span></label>
                    <?php if(!empty($record->image)): ?>
                        <img src="<?php echo e(asset($record->image, $secure = null)); ?>" alt="" title="" class="fancybox img_box" id="prev_img" />
                    <?php else: ?>
                        <img src="<?php echo e(asset('admin/images/no-image.png', $secure = null)); ?>" alt="" title="" class="fancybox img_box" id="prev_img" />
                    <?php endif; ?>
                    <a href="<?php echo url('/uploads/filemanager/dialog.php?type=1&field_id=image') ?>" data-fancybox-type="iframe" class="btn btn-info fancy">Insert</a>
                    <button class="btn btn-danger remove_box_image" type="button">Remove</button>
                    <button class="btn btn-warning prev_box_image" type="button" style="display: none;">Previous Image</button>
                    <input type="hidden" value="<?php echo isset($record->image)?asset($record->image):'' ?>"  name="image" class="form-control img_val" id="image">
                     <?php if($errors->has('image')): ?>
                        <span class="help-block">
                            <strong><?php echo e($errors->first('image')); ?></strong>
                        </span>
                    <?php endif; ?>
                </div>
                <div class="form-group">
                    <label class="control-label" for="published_date">Published Date <span class="text-danger">*</span></label>
                    <input type="text" class="form-control datepicker" id="published_date" name="published_date" autocomplete="off" value="<?php echo e($record->published_date); ?>" >
                </div>
                <div class="form-group">
                    <label for="status">Status</label>
                    <select name="status" id="statusid" class="form-control">
                        <option value="1" <?= isset($record->status) && ($record->status == '1')? 'selected' : '' ?> ><?php echo PUBLISH; ?></option>
                        <option value="0" <?= isset($record->status) && ($record->status == '0')? 'selected' : '' ?> ><?php echo UNPUBLISH; ?></option>
                    </select>
                </div>
               <div class="form-group">
                    <button type="submit" class="btn btn-success">Update</button>
                    <button type="reset" class="btn btn-danger resetbtn">Clear</button>
                </div>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin/app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>