<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title><?php echo e($sitedetail->title_en); ?> || Login ||</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="<?php echo e(asset('admin/bootstrap/css/bootstrap.min.css')); ?>">
  
  
  <link rel="stylesheet" href="<?php echo e(asset('admin/dist/css/AdminLTE.min.css')); ?>">
  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition login-page">
<div class="login-box">
  <div class="login-logo">
    <b>Log</b>In
    <br>
    
  </div>
  <div class="login-box-body">
    <p class="login-box-msg">Provide your login information.</p>
    <?php if(Session::has('message')): ?>
      <div class="alert alert-danger"><?php echo e(Session::get('message')); ?></div>
    <?php endif; ?>
    <form action="<?php echo e(route('login')); ?>" method="post">
      <?php echo e(csrf_field()); ?>

      <div class="form-group has-feedback<?php echo e($errors->has('username') ? ' has-error' : ''); ?>">
        <input type="text" class="form-control" name="username" placeholder="UserName" value="<?php echo e(old('username')); ?>">
        <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
         <?php if($errors->has('username')): ?>
            <span class="help-block">
                <strong><?php echo e($errors->first('username')); ?></strong>
            </span>
        <?php endif; ?>
      </div>
      <div class="form-group has-feedback<?php echo e($errors->has('password') ? ' has-error' : ''); ?>">
        <input type="password" class="form-control" name="password" placeholder="Password">
        <span class="glyphicon glyphicon-lock form-control-feedback"></span>
         <?php if($errors->has('password')): ?>
            <span class="help-block">
                <strong><?php echo e($errors->first('password')); ?></strong>
            </span>
        <?php endif; ?>
      </div>
      <div class="row">
        <div class="col-xs-8"></div>
        <div class="col-xs-4">
          <button type="submit" class="btn btn-primary btn-block btn-flat">Log In</button>
        </div>
      </div>
    </form>
  </div>
</div>


</body>
</html>