
<?php $__env->startSection('content'); ?>
<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
    <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title"><?php echo e($page_header); ?></h3>
          <span class="pull-right"><a href="<?php echo e(route('posts.index')); ?>" class="btn btn-warning"><i class="fa fa-chevron-left" aria-hidden="true"></i>&nbsp;  View List </a></span>
      </div>
      <div class="box-body">
        <form class="form-horizontal" method="POST" action="<?php echo e(route('posts.update', $record->id)); ?> " id="frm-post">
            <?php echo e(csrf_field()); ?>

            <?php echo e(method_field('PATCH')); ?>

            <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                <div class="form-group">
                    <label class="control-label" for="title">Title <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="title" name="title" value="<?php echo e($record->title); ?>" >
                    <?php if($errors->has('title')): ?>
                    <span class="help-block">
                        <strong><?php echo e($errors->first('title')); ?></strong>
                    </span>
                    <?php endif; ?>
                </div>
                <div class="form-group">
                    <label class="control-label" for="slug">Slug <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="slug" name="slug" value="<?php echo e($record->slug); ?>" >
                    <?php if($errors->has('slug')): ?>
                    <span class="help-block">
                        <strong><?php echo e($errors->first('slug')); ?></strong>
                    </span>
                    <?php endif; ?>
                </div>
                <div class="form-group">
                    <label class="control-label" for="description">Description <span class="text-danger">*</span></label>
                    <br>
                    <textarea id="my-editor" class="tinymce" name="description" placeholder="Place some text here" ><?php echo e($record->description); ?></textarea>
                    <?php if($errors->has('description')): ?>
                    <span class="help-block">
                        <strong><?php echo e($errors->first('description')); ?></strong>
                    </span>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="form-group">
                        <label for="published_date">Choose Category</label>
                        <div class="col-md-12" style="height: 250px; overflow-y: scroll;">
                            <ul class="list-unstyled">
                                <?php if(!empty($categorylist)): ?>
                                <?php $__currentLoopData = $categorylist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><input type="checkbox" name="category[]" value="<?php echo e($cat->id); ?>" 
                                    <?php $__currentLoopData = $record->category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $postcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($postcat->id == $cat->id): ?>
                                    checked 
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> > <?php echo e($cat->title); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                        <div class="form-group">
                         <label class="control-label">Featured Image</label>
                         <?php if (!empty($record->image)) { ?>
                         <img src="<?php echo url($record->image) ?>" alt="" title="" id="prev_img" />
                         <?php } else { ?>
                         <img src="<?php echo e(asset('admin/images/no-image.png', $secure = null)); ?>" alt="" title="" id="prev_img" />
                         <?php } ?>
                         <a href="<?php echo url('/uploads/filemanager/dialog.php?type=1&field_id=image') ?>" data-fancybox-type="iframe" class="btn btn-info fancy">Insert</a>
                         <button class="btn btn-danger remove_box_image" type="button">Remove</button>
                         <button class="btn btn-warning prev_box_image" type="button" style="display: none;">Previous Image</button>
                         <input type="hidden" value="<?php echo isset($record->image)?url($record->image):'' ?>"  name="image" class="form-control" id="image">
                     </div>
                     <div class="form-group">
                        <label class="control-label" for="published_date">Published Date <span class="text-danger">*</span></label>
                        <input type="text" class="form-control datepicker" id="published_date" name="published_date" value="<?php echo e($record->published_date); ?>" >
                    </div>
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select name="status" id="statusid" class="form-control">
                            <option value="1" <?= isset($record->status) && ($record->status == '1')? 'selected' : '' ?> ><?php echo PUBLISH; ?></option>
                            <option value="0" <?= isset($record->status) && ($record->status == '0')? 'selected' : '' ?> ><?php echo UNPUBLISH; ?></option>
                        </select>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="reset" class="btn btn-danger resetbtn">Clear</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
</div>
<div class="clearfix"></div>
<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">
    $('#frm-post').submit(function(event) {
        var checked = $("input[type=checkbox]:checked").length;
        if(!checked) {
            alert("You must check at least one checkbox.");
            return false;
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin/app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>