<?php
$jsondata = getJsonData('marketinformationapi');
?>
<div class="table-responsive mt-10">
    <table class="table table-hover table-striped">
        <thead>
            <tr>
                <th>Index</th>
                <th>Current</th>
                <th colspan="3" class="text-right">Change</th>
            </tr>
        </thead>
        <tbody>
            <?php if(!empty($jsondata)): ?>
            <?php $__currentLoopData = $jsondata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kl => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($item->issubindex == '1'): ?>
            <tr class=" text-white font-weight-bold <?php echo e(($item->status == 'green') ? 'bg-success' : 'bg-danger'); ?>">
                <td><?php echo e($item->name); ?></td>
                <td><?php echo e(number_format($item->index_value, 2)); ?></td>
                <td class="text-right">
                    <?php echo e(number_format($item->diff)); ?>

                    [<?php echo e($item->per_change); ?>%]
                    <i class="lni lni-<?php echo e(($item->per_change > 0) ? 'arrow-up' : 'arrow-down'); ?>"></i>
                </td>
            </tr>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>