<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['namespace' => 'site'], function (){
	Route::get('/', 'HomeController@index')->name('index');
	Route::get('messagedetail/{Slug}', 'HomeController@messageDetail' )->name('message.detail');
	Route::get('detail/{Slug}', 'PostController@postDetail' )->name('post.detail');
	Route::get('pages/{slug}', 'HomeController@pagesDetail' )->name('page.detail');
	Route::any('insertfeedback', 'HomeController@insertfeedback')->name('insertfeedback');
	Route::get('contact-us', 'HomeController@contactUs')->name('contact');
	Route::get('downloads', 'HomeController@downloadList')->name('downloads');
	Route::get('category/{slug}', 'HomeController@categoryList' )->name('category.list');
	Route::get('nepsechartdata', 'HomeController@nepsechartdata')->name('nepsechartdata');
	Route::get('career', 'HomeController@career')->name('career');
	Route::get('management-team', 'StaffController@staffList')->name('stafflist');
	Route::get('board-members', 'StaffController@boardMember')->name('boardmember');
	Route::get('ipo-result', 'HomeController@iporesult')->name('iporesult');
	Route::any('search', 'HomeController@searchBox')->name('search');
	Route::get('payment/fone-pay', 'HomeController@paymentDetail' )->name('payment.detail');
	Route::get('share-calculator', 'HomeController@shareCalculator' )->name('sharecalculator');
	
});

Route::group(['prefix' => 'ajax','namespace' => 'site'], function (){
	Route::get('sharepricescroll', 'HomeController@sharePriceScroll')->name('sharepricescroll');
	Route::get('latestnewsscroll', 'HomeController@latestNewsScroll')->name('latestnewsscroll');
	Route::get('marketinformation', 'HomeController@marketInformation')->name('marketinformation');
	Route::get('marketsummary', 'HomeController@marketSummary')->name('marketsummary');
	Route::get('topgainer', 'HomeController@topGainer')->name('topgainer');
	Route::get('marketindex', 'HomeController@marketIndex')->name('marketindex');
	Route::get('marketsubindex', 'HomeController@marketSubIndex')->name('marketsubindex');
	Route::get('investment', 'HomeController@investmentData')->name('investment');
});

// Admin Web Route
Route::group(['prefix' => 'my-admin','namespace' => 'admin'], function (){
	Route::get('login', 'AdminLoginController@login')->name('login.page');
	Route::post('login', 'AdminLoginController@loginCheck')->name('login');
});


Route::group(['prefix' => 'u-admin', 'namespace' => 'admin', 'middleware'   => ['adminlogincheck','roles']], function (){
	Route::get('registeruser', 'AdminLoginController@userRegister')->name('user.create');
	Route::post('registeruser', 'AdminLoginController@userRegisterData')->name('userregister');
	Route::get('dashboard', 'AdminLoginController@dashboard')->name('dashboard');
	Route::get('user/list', 'AdminLoginController@adminUserList')->name('user.list');
	Route::get('user/{id}/edit', 'AdminLoginController@editUser')->name('user.edit');
	Route::any('updateuser/{id}', 'AdminLoginController@updateuser')->name('user.update');
	Route::get('user/delete/{id}', ['as' => 'user.delete', 'uses' => 'AdminLoginController@deleteUser']);
	Route::any('logout', 'AdminLoginController@logout')->name('logout');

	Route::any('updateuserprofile/{id}', 'AdminProfileController@updateuser')->name('userprofile.update');
	Route::get('userprofile/{id}/edituserprofile', 'AdminProfileController@editUserProfile')->name('userprofile.editprofile');

	Route::get('ui-skin', 'AdminUIComponentController@uiManagement')->name('ui_skin.index');
	Route::get('ui-skin-change/{id}', 'AdminUIComponentController@uiSkinChange')->name('ui_skin.change');

	Route::get('success-login', 'AdminLoginLogsController@successLogin')->name('successlogin');
	Route::get('fail-login', 'AdminLoginLogsController@failLogin')->name('faillogin');
	Route::get('menu', 'AdminMenuController@index')->name('menu');
	// User Group
	Route::resource('usergroup', 'AdminGroupController');
	Route::get('usergroup/delete/{id}', ['as' => 'usergroup.delete', 'uses' => 'AdminGroupController@destroy']);
	// Role Access
	Route::resource('role-access', 'AdminRoleAccessController');
	Route::get('role-access/delete/{id}', ['as' => 'role-access.delete', 'uses' => 'AdminRoleAccessController@destroy']);
    Route::get('roleChangeAccess/{allowId}/{id}','AdminRoleAccessController@changeAccess');
    Route::get('setting','AdminSiteSettingController@setting')->name('setting');
    Route::post('setting-update','AdminSiteSettingController@updateSetting')->name('update.setting');

	Route::resource('pages', 'AdminPagesController');
	Route::get('pages/delete/{id}', ['as' => 'pages.delete', 'uses' => 'AdminPagesController@destroy']);
	// category
	Route::resource('category', 'AdminCategoryController');
	Route::get('category/delete/{id}', ['as' => 'category.delete', 'uses' => 'AdminCategoryController@destroy']);
	// posts
	Route::resource('posts', 'AdminPostsController');
	Route::get('posts/delete/{id}', ['as' => 'posts.delete', 'uses' => 'AdminPostsController@destroy']);
	// downloads
	Route::resource('downloads', 'AdminDownloadsController');
	Route::get('downloads/delete/{id}', ['as' => 'downloads.delete', 'uses' => 'AdminDownloadsController@destroy']);
	// slider
	Route::resource('slider', 'AdminSliderController');
	Route::get('slider/delete/{id}', ['as' => 'slider.delete', 'uses' => 'AdminSliderController@destroy']);

	// Contact
	Route::resource('contact', 'AdminContactController');
	Route::get('contact/delete/{id}', ['as' => 'contact.delete', 'uses' => 'AdminContactController@destroy']);
	// Career
	Route::resource('career', 'AdminCareerController');
	Route::get('career/delete/{id}', ['as' => 'career.delete', 'uses' => 'AdminCareerController@destroy']);
	// message_from_md
	Route::resource('message', 'AdminMessageMDController');
	Route::get('message/delete/{id}', ['as' => 'message.delete', 'uses' => 'AdminMessageMDController@destroy']);

	// message_from_md
	Route::resource('department', 'AdminDepartmentController');
	Route::get('department/delete/{id}', ['as' => 'department.delete', 'uses' => 'AdminDepartmentController@destroy']);
	
	// message_from_md
	Route::resource('staffdetail', 'AdminStaffDetailController');
	Route::get('staffdetail/delete/{id}', ['as' => 'staffdetail.delete', 'uses' => 'AdminStaffDetailController@destroy']);

	// pop_up
	Route::resource('popup', 'AdminPopupController');
	Route::get('popup/delete/{id}', ['as' => 'popup.delete', 'uses' => 'AdminPopupController@destroy']);

	// pop_up
	Route::resource('brokerbranch', 'AdminBrokerBranchController');
	Route::get('brokerbranch/delete/{id}', ['as' => 'brokerbranch.delete', 'uses' => 'AdminBrokerBranchController@destroy']);

});

//Auth::routes();