@extends('site/app')
@section('title', $page_header)
@section('keywords', $sitedetail->meta_keywords)
@section('description', $sitedetail->meta_descriptions)
@section('fb_image', $sitedetail->fb_image)
@section('breadcrumbs')
@section('breadcrumb_title', $page_header)
{{ Breadcrumbs::render('contact', $page_header) }}
@endsection
<?php
 try {
    $apidata = @file_get_contents($apilist['iporesultapi']);
    $jsondata = json_decode($apidata, true);
  } catch (DecryptException $e) {
    $jsondata = null;
  }
?>
@section('main-content')
<section id="vc-inner-content" class="common-inner">
	<div class="container">
		<div class="row">
			<div class="col* col-md-8 col-lg-8 left-col">
				<div class="common-form">
					<form method="post" class="form-horizontal" id="frm-iporesultsearch">
						{{ csrf_field() }}
						<div class="row">
							<div class="col* col-sm-12 col-md-5">
								<label for="lbl_Company" class="form-input">Select Company : <span class="text-danger">*</span></label>
								<select class="form-control" name="companyid" id="companyid">
									@if(!empty($jsondata))
										@foreach($jsondata as $kl =>$item)
											<option value="{{ $item['id'] }}">{{ $item['companyname'] }}</option>
										@endforeach
									@endif
								</select>
								<p>Source : <a href="http://nepsekhabar.com/iporesult" target="_blank">nepsekhabar.com</a></p>
							</div>
							<div class="clearfix"></div>
							<br>
							<div class="col* col-sm-5 col-md-5">
								<label for="lbl_boid" class="form-input">BOID : <span class="text-danger">*</span></label>
								<input type="number" name="boid" id="boid" class="form-control" placeholder="Enter 16 digit BOID Number" required value="<?php echo isset($_POST['boid'])?$_POST['boid']:''; ?>">
								<span class="text-danger error" id="boid-error"></span>
							</div>
							<div class="col* col-sm-12 col-md-2">
								<label for="lbl_Company" class="form-input">&nbsp;</label>
								<div class="cal-btn">
									<button type="button" id="btn_frm_iporesult" class="btn"><i class="fa fa-search"></i> Check</button>
								</div>
							</div>
							<h5 id="loading" class="d-none"></h5>
						</div>
					</form>
					<table class="table table-striped d-none" id="iporesult-table">
						<thead>
							<tr>
								<th>S.No</th>
								<th>Name</th>
								<th>BOID</th>
								<th>Applied Kitta</th>
								<th>Alloted Kitta</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td>1</td>
								<td id="name"></td>
								<td id="boid_result"></td>
								<td id="applied_kitta"></td>
								<td id="alloted_kitta"></td>
							</tr>
							<tr><td colspan="4"><h5 class="text-success">Congratulation, You have been alloted ...</h5></td></tr>
						</tbody>
					</table>
					<h2 class="text-danger" id="notalloted"></h2>
				</div>
			</div>
			<div class="col* col-md-4 col-lg-4 right-col">
				@include('site.sidebar.news')
				@include('site.sidebar.downloads')
			</div>
		</div>
	</div>
</section>
@endsection