@extends('site/app')
@section('title', $page_header)
@section('keywords', $sitedetail->meta_keywords)
@section('description', $sitedetail->meta_descriptions)
@section('fb_image', $sitedetail->fb_image)
@section('breadcrumbs')
{{ Breadcrumbs::render('contact', $page_header) }}
@endsection
@section('main-content')
<section id="vcMainContent" class="mainContent">
	<div class="container">
		<div class="teamInfos tableInfos">
			<div class="card card-nav-tabs card-plain">
				<div class="card-header card-header-danger">
				<div class="nav-tabs-navigation">
					<div class="nav-tabs-wrapper">
					<ul class="nav nav-tabs" data-tabs="tabs">
						@if(!empty($list))
						@foreach($list as $k => $item)
							<li class="nav-item">
								<a class="nav-link @if($k == 0){{ 'active' }} @endif" href="#team-{{ $item->id }}" data-toggle="tab">{{ $item->broker_name }}</a>
							</li>						
						@endforeach
						@endif
					</ul>
					</div>
				</div>
				</div>
				<div class="tab-content">
					@if(!empty($list))
						@foreach($list as $kl => $item)
						<div class="tab-pane @if($kl == 0){{ 'active' }} @endif" id="team-{{ $item->id }}">
							@if(!empty($item->departmentlist))
							@foreach($item->departmentlist as $kl => $dep)
							<div class="teamTabList">
								<h3 class="teamTitle"><span>{{ $dep->title }}</span></h3>
								<div class="row">
									@if(!empty($dep->stafflist))
									@foreach($dep->stafflist as $sl => $staff)
									<div class="col* col-md-6 col-lg-3 teamList">
										<div class="ourTeam">
											@if(!empty($staff->image))
											<div class="pic">
												<img src="{{ url($staff->image) }}" class="img-responsive" alt="{{ $staff->name }}" title="{{ $staff->name }}">
											</div>
											@endif
											<div class="teamContent">
											<h3 class="title">{{ $staff->name }}</h3>
												<span class="post">{{ $staff->position }}</span>
												<span class="post">{{ $staff->phone_no }}</span>
											</div>
											<ul class="social"> 
											<li>
												<a href="mailto:{{ $staff->email }}" title="{{ $staff->email }}">
													<i class="facebookIc lni-envelope"></i>
												</a>
											</li>
											</ul>
										</div>
									</div>
									@endforeach
									@endif		
								</div>
							</div>
							@endforeach
							@endif
						</div>
						@endforeach
					@endif
				</div>
			</div>
		</div>
	</div>
</section>
@endsection