@extends('site.app')
@section('title', $page_header)
@section('keywords', $sitedetail->meta_keywords)
@section('description', $sitedetail->meta_descriptions)
@section('fb_image', $sitedetail->fb_image)
@section('breadcrumbs')
@section('breadcrumb_title', $page_header)
{{ Breadcrumbs::render('contact', $page_header) }}
@endsection
@section('main-content')
<section id="vc-inner-content" class="common-inner">
	<div class="container">
		<div class="row">
			<div class="col* col-md-8 col-lg-8 left-col side-bar">
				<h3>{{ $page_header.' result of : '. $query }} </h3>
				<br>
				@if(!empty($pagelist))
				<div class="cardBox">
					<h2 class="sideBarTitle">Pages</h2>
					<div class="widgetBg downloadBg">
						<ul>
							@foreach($pagelist as $kl => $item)
							<li>
								<p>
									<a href="{{ route('page.detail',$item->slug) }}">{{ $item->title }}</a>
								</p>
							</li>
							@endforeach
						</ul>
					</div>
				</div>
				@endif
				<br><br>
				@if(!empty($postlist))
				<div class="cardBox">
					<h2 class="sideBarTitle">Posts</h2>
					<div class="widgetBg downloadBg">
						<ul>
							@foreach($postlist as $kl => $item)
							<li>
								<p>
									<a href="{{ route('post.detail',$item->slug) }}">{{ $item->title }}</a>
								</p>
							</li>
							@endforeach
						</ul>
					</div>
				</div>
				@endif
				<br><br>
				@if(!empty($downloadlist))
				<div class="cardBox">
					<h2 class="sideBarTitle">Download</h2>
					<div class="widgetBg downloadBg">
						<ul>
							@foreach($downloadlist as $kl => $item)
							<li>
								<p>
									<a href="{{ $item->file }}"  target="_blank">{{ $item->title }}</a>
									<span class="dateCol">{{ $item->published_date }}</span>
								</p>
							</li>
							@endforeach
						</ul>
					</div>
				</div>
				@endif
			</div>
			<div class="col* col-md-4 col-lg-4 right-col">
				@include('site.sidebar.news')
			</div>
		</div>
	</div>
</section>
@endsection