@extends('site/app')
@section('title', $detail->title)
@section('keywords', $sitedetail->meta_keywords)
@section('description', str_limit(strip_tags($detail->description), 200) ?? $sitedetail->meta_descriptions)
@section('fb_image', $sitedetail->fb_image)
@section('breadcrumbs')
{{ Breadcrumbs::render('category', $detail) }}
@endsection
@section('main-content')
<section id="vcMainContent" class="mainContent">
	<div class="container">
		<div class="singleInfos">
			<div class="row">
				<div class="col* col-md-12 col-lg-8 colLeft">
					<div class="cardBox">
						<div class="postDetails">
							<h2 class="singleTitle">{{ $detail->title }}</h2>
							@if($detail->image != '')
							<div class="contentImg">
								<figure>
									<img src="{{ asset($detail->image, $secure = null) }}" class="img-responsive" alt="{{ $detail->title }}" title="{{ $detail->title }}">
								</figure>
							</div>
							@endif
							<p class="singledate"><i class="la la-calendar"></i> {{ $detail->published_date }}</p>
							{!! $detail->description  !!}
						</div>
					</div>
				</div>
				<div class="col* col-md-12 col-lg-4 colRight">
					@include('site.sidebar.news')
					@include('site.sidebar.notice')
				</div>
			</div>
		</div>
	</div>
</section>
@endsection