@extends('site.app')
@section('title', $page_header)
@section('keywords', $sitedetail->meta_keywords)
@section('description', $sitedetail->meta_descriptions)
@section('fb_image', $sitedetail->fb_image)
@section('main-content')
@include('site.layout.slider')
<section id="vcAboutNews" class="aboutNews sectionTop">
    <div class="container">
        <div class="row">
            @if(isset($showhomepage))
            <div class="col* col-md-8 col-lg-8 aboutSec">
                <h2 class="titleHead"><span>{{ isset($showhomepage->title)?$showhomepage->title:'' }}</span></h2>
                <div class="post-detail">
                    {!! str_limit(strip_tags($showhomepage->description), $limit = 1100, $end = '...')  !!}
                </div>
                <a href="{{ route('page.detail',$showhomepage->slug) }}"class="btn btnSubmit">read more</a>
            </div>
            @endif
            <div class="col* col-md-4 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <h2 class="titleHead"><span>For Payment</span></h2>
                        <div class="broker__charger">
                            <a href="{{ route('payment.detail') }}"><img src="{{ asset('public/site/images/payment.png') }}" class="w-100"></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section id="vcmarketBox" class="marketBox">
    <div class="container">
        <div class="row">
            <div class="col* col-md-8 col-lg-9 marketSec mb-10">
                @include('site.components.nepsechart')
            </div>
            <div class="col* col-md-4 col-lg-3 mb-10" id="marketindex">
            </div>
        </div>
    </div>
</section>
<section id="vcmarketBox" class="marketBox">
    <div class="container">
        <h2 class="titleHead"><span>Market Information</span></h2>
        <div id="marketsummary">
            
        </div>
        <div id="marketsubindex">
            
        </div>
    </div>
</section>
<section id="vcmarketBox" class="marketBox">
    <div class="container">
        <div class="row">
            <div class="col* col-md-6 col-lg-6 newsSec mb-10">
                <div class="card">
                    <div class="card-body">
                        <h2 class="titleHead"><span>News & Notices</span></h2>
                        <div class="newsScroll">
                            <ul>
                                @if(count($newsevent)>0)
                                @foreach($newsevent as $kl => $item)
                                <li>
                                    <h4><a target="_blank" href="{{ route('post.detail',$item->slug) }}">{{ str_limit($item->title, $limit = 65, $end = '...') }}</a></h4>
                                    <span>{{ $item->published_date }}</span>
                                    <p>{!! str_limit(trim(strip_tags($item->description)), $limit = 100, $end = '...')  !!}</p>
                                </li>
                                @endforeach
                                @else
                                <li><h4>{!! NO_RECORD !!}</h4></li>
                                @endif
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col* col-md-6 col-lg-6 newsSec mb-10">
                <div class="card">
                    <div class="card-body">
                        <h2 class="titleHead"><span>Broker Charges</span></h2>
                        <div class="broker__charger">
                            <div class="table-responsive">
                                <table class="table table-striped table-hover text-nowrap">
                                    <thead>
                                        <tr>
                                            <th colspan="2">खरिद तथा विक्री कारोबारमा धितोपत्र दलाली बापत लिन पाउने सेवा शुल्क</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>रु. ५०,०००।– सम्म</td>
                                            <td>०.४०  %</td>
                                        </tr>
                                        <tr>
                                            <td>रु. ५०,०००।– माथि रु.५,००,०००।– सम्म</td>
                                            <td>०.३७ %</td>
                                        </tr>
                                        <tr>
                                            <td>रु. ५,००,०००।– माथि रु. २०,००,०००।–सम्म</td>
                                            <td>०.३४ %</td>
                                        </tr>
                                        <tr>
                                            <td>रु. २०,००,०००।– माथि रु. १,००,००,०००।– सम्म</td>
                                            <td>०.३० %</td>
                                        </tr>
                                        <tr>
                                            <td>रु. १,००,००,०००।– माथि</td>
                                            <td>०.२७ %</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover text-nowrap">
                                    <thead>
                                        <tr>
                                            <th colspan="2">निक्षेप सदस्यले लिने शुल्क</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>खाता खोल्ने शुल्क</td>
                                            <td>रु. १५० (एक पटक मात्र)</td>
                                        </tr>
                                        <tr>
                                            <td>खाता नविकरण तथा संचालन शुल्क</td>
                                            <td>रु. १०० (प्रति आ.व)</td>
                                        </tr>
                                        <tr>
                                            <td>धितोपत्र हस्तान्तरण शुल्क</td>
                                            <td>रु. २५ (प्रति कम्पनी, प्रति दिन)</td>
                                        </tr>
                                        <tr>
                                            <td>धितोपत्र रोक्का तथा फुकुवा शुल्क</td>
                                            <td>रु. ५० प्रति कम्पनी</td>
                                        </tr>
                                        <tr>
                                            <td>घरायसी नामसारी शुल्क</td>
                                            <td>२ प्रतिशत वा न्यूनत्तम रु.२००</td>
                                        </tr>
                                        <tr>
                                            <td>मृत्यु नामसारी शुल्क</td>
                                            <td>०.५ प्रतिशत वा न्यूनत्तम रु.२५</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section id="vcSellBuyBox" class="sellBuyBox sectionTop">
    <div class="container">
        <div class="row">
            <div class="col* col-md-6 col-lg-4 sellBuyCalc mb-10">
                <div class="card">
                    <div class="card-body">
                        <h2 class="titleHead"><span>Buy Calculator</span></h2>
                        <div class="customForm">
                            <form>
                                <div class="form-group">
                                    <label class="labelTitle">Quantity</label>
                                    <input type="number" class="form-control" id="buy_share_qty" placeholder="Enter Number Only">
                                    <span class="text-danger" id="buy-share-qty"></span>
                                </div>
                                <div class="form-group">
                                    <label class="labelTitle">Rate (Rs)</label>
                                    <input type="number" class="form-control" id="purchase_price" placeholder="Enter Number Only">
                                    <span class="text-danger" id="buy-purchase_price"></span>
                                </div>
                                <div class="submitBtn">
                                    <button type="button" id="btn-buysharecalculator" class="btn btnSubmit">calculate</button>
                                </div>
                                <br>
                                <div id="buy_note" class="d-none">
                                    <table class="table table table-sm table-condensed table-hover">
                                        <tbody>
                                            <tr>
                                                <td><span class="sc-title">Total Amount</span></td><td><span class="sc-value pull-right" id='buy_total_amount'></span></td>
                                            </tr>
                                            <tr>
                                                <td><span class="sc-title">* Comission</span></td><td><span class="sc-value pull-right" id='buy_broker_commision'></span></td>
                                            </tr>
                                            <tr>
                                                <td><span class="sc-title">SEBON FEE</span></td><td><span class="sc-value pull-right" id='buy_sebon_fee'></span></td>
                                            </tr>
                                            <tr>
                                                <td><span class="sc-title">DP Charge</span></td><td><span class="sc-value pull-right" id='buy_dp_charge'></span></td>
                                            </tr>
                                            <tr class="purchase d-none">
                                                <td><span class="sc-title">Total Amount Payable (Rs)</span></td><td><span class="sc-value pull-right" id='buy_total_payable_amount'></span></td>
                                            </tr>
                                            <tr class="purchase d-none">
                                                <td><span class="sc-title">Cost Price Per Share (Rs)</span></td><td><span class="sc-value pull-right" id='buy_cost_price_per_unit'></span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <div class="clearfix"></div>
                                    <h3><strong>Note:</strong></h3>
                                    <p id="buy_comission_info"></p>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col* col-md-6 col-lg-4 sellBuyCalc mb-10">
                <div class="card">
                    <div class="card-body">
                        <h2 class="titleHead"><span>Sell Calculator</span></h2>
                        <div class="customForm">
                            <form>
                                <div class="form-group">
                                    <label class="labelTitle">Quantity</label>
                                    <input type="number" class="form-control" id="sell_share_qty" placeholder="Enter Number Only">
                                    <span class="text-danger" id="sell-share-qty"></span>
                                </div>
                                <div class="form-group">
                                    <label class="labelTitle">Purchase Rate (Rs)</label>
                                    <input type="number" class="form-control" id="sell_purchase_price" placeholder="Enter Number Only">
                                    <span class="text-danger" id="sell-purchase_price"></span>
                                </div>
                                <div class="form-group">
                                    <label class="labelTitle">Selling Rate (Rs)</label>
                                    <input type="number" class="form-control" id="selling_price" placeholder="Enter Number Only">
                                    <span class="text-danger" id="sell-selling_price"></span>
                                </div>
                                <div class="form-group">
                                    <label class="labelTitle">Investor Type</label>
                                    <select id="investor" class="form-control" name="investor">
                                        <option value="GI">Individual</option>
                                        <option value="II">Institutional</option>
                                    </select>
                                </div>
                                <div class="submitBtn">
                                    <button type="button" id="btn-sellsharecalculator" class="btn btnSubmit">calculate</button>
                                </div>
                                <br>
                                <div  id="sell_note" class="d-none">
                                    <table class="table table table-sm table-condensed table-hover">
                                        <tbody>
                                            <tr class="selling d-none">
                                                <td>Investor Type</td><td><span class="sc-value pull-right" id='sell_investor_type'></span></td>
                                            </tr>
                                            <tr>
                                                <td><span class="sc-title">Total Amount</span></td><td><span class="sc-value pull-right" id='sell_total_amount'></span></td>
                                            </tr>
                                            <tr>
                                                <td><span class="sc-title">* Comission</span></td><td><span class="sc-value pull-right" id='sell_broker_commision'></span></td>
                                            </tr>
                                            <tr>
                                                <td><span class="sc-title">SEBON FEE</span></td><td><span class="sc-value pull-right" id='sell_sebon_fee'></span></td>
                                            </tr>
                                            <tr>
                                                <td><span class="sc-title">DP Charge</span></td><td><span class="sc-value pull-right" id='sell_dp_charge'></span></td>
                                            </tr>
                                            <tr class="selling d-none">
                                                <td><span class="sc-title">Total Amount Receivable (Rs)</span></td><td><span class="sc-value pull-right" id='sell_total_receivable_amount'></span></td>
                                            </tr>
                                            <tr class="selling d-none">
                                                <td><span class="sc-title">Capital Gain Tax (5%) (Rs)</span></td><td><span class="sc-value pull-right" id='sell_capitaltax'></span></td>
                                            </tr>
                                            <tr class="selling profit_loss d-none">
                                                <td><span class="sc-title">Profit/Loss (Rs)</span></td><td><span class="sc-value pull-right" id='sell_net_profit_loss'></span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <div class="clearfix"></div>
                                    <h3><strong>Note:</strong></h3>
                                    <p id="sell_comission_info"></p>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col* col-md-12 col-lg-4 newsSec">
                <div class="card">
                    <div class="card-body">
                        <h2 class="titleHead"><span>Download</span></h2>
                        <div class="newsScroll">
                            <ul>
                                @if(count($newsevent)>0)
                                @foreach($newsevent as $kl => $item)
                                <li>
                                    <h4><a target="_blank" href="{{ route('post.detail',$item->slug) }}">{{ str_limit($item->title, $limit = 65, $end = '...') }}</a></h4>
                                    <span>Download</span>
                                </li>
                                @endforeach
                                @else
                                <li><h4>{!! NO_RECORD !!}</h4></li>
                                @endif
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section id="vcSellBuyBox" class="sellBuyBox sectionTop">
    <div class="container" id="marketmovers">

    </div>
</div>
</section>
<section id="vcSellBuyBox" class="sellBuyBox sectionTop">
    <div class="container" id="investment">

    </div>
</div>
</section>
@if($popupmessage->isNotEmpty())
<?php $count = 1; $totalcount = count($popupmessage)+1; ?>
<div class="overlay-bg">
@foreach($popupmessage as $kl => $item)
<div class="overlay-content popup{{ $count++ }}">
    <h1>{{ $item->title }}</h1>
    <p><img src="{{ asset($item->image, $secure = null) }}" title="{{ $item->title }}" ></p>
    <button class="close-btn" id="{{ ($totalcount == $count)?'':$count }}" data-showpopup="{{ ($totalcount == $count)?'':$count }}">X</button>
</div>
@endforeach
</div>
@push('vi_script')
<link href="{{ asset('site/js/overlay/overlay.min.css') }}" rel="stylesheet" type="text/css">
<script type="text/javascript" src="{{ asset('site/js/overlay/overlay.min.js') }}"></script>
@endpush
@endif
@endsection