@extends('site.app')
@section('title', $page_header)
@section('keywords', $sitedetail->meta_keywords)
@section('description', str_limit(strip_tags($sitedetail->meta_descriptions), 200))
@section('fb_url', Request::url())
@section('fb_published_date',date('Y-m-d'))
@section('fb_image', asset($socaildetail['fb_image']))
@section('main-content')
@include('site.layout.slider')
<section id="vcAboutNews" class="aboutNews sectionTop">
    <div class="container">
        <div class="row">
            @if(isset($showhomepage))
            <div class="col* col-md-6 col-lg-7 aboutSec">
              <h2 class="titleHead"><span>{{ isset($showhomepage->title)?$showhomepage->title:'' }}</span></h2>
              <div class="post-detail">
                  {!! str_limit(strip_tags($showhomepage->description), $limit = 1100, $end = '...')  !!}
              </div>
              <a href="{{ route('page.detail',$showhomepage->slug) }}"class="btn btnSubmit">read more</a>
          </div>
          @endif
          <div class="col* col-md-6 col-lg-5 newsSec">
                <div class="card">
                    <div class="card-body">
                        <h2 class="titleHead"><span>News & Notices</span></h2>
                        <div class="newsScroll">
                            <ul>
                                @if(count($newsevent)>0)
                                     @foreach($newsevent as $kl => $item)
                                        <li>
                                          <h4><a target="_blank" href="{{ route('post.detail',$item->slug) }}">{{ str_limit($item->title, $limit = 65, $end = '...') }}</a></h4>
                                            <span>{{ $item->published_date }}</span>
                                            <p>{!! str_limit(trim(strip_tags($item->description)), $limit = 100, $end = '...')  !!}</p>
                                        </li>
                                     @endforeach
                                @else
                                 <li><h4>{!! NO_RECORD !!}</h4></li>
                                @endif
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section id="vcmarketBox" class="marketBox">
    <div class="container">
        <div class="row">
            <div class="col* col-md-6 col-lg-6 marketSec">
                @include('site.components.nepsechart')
            </div>
            <div class="col* col-md-6 col-lg-6 tableInfos">
                <div id="topgainersection"></div>
            </div>
        </div>
    </div>
</section>

<section id="vcSellBuyBox" class="sellBuyBox sectionTop">
    <div class="container">
        <div class="row">
            <div class="col* col-md-6 col-lg-6 sellBuyCalc">
                <div class="card">
                    <div class="card-body">
                        <h2 class="titleHead"><span>Buy Calculator</span></h2>
                            <div class="customForm">
                            <form>
                                <div class="form-group">
                                    <label class="labelTitle">Quantity</label>
                                    <input type="number" class="form-control" id="buy_share_qty" placeholder="Enter Number Only">
                                    <span class="text-danger" id="buy-share-qty"></span>
                                </div>
                                <div class="form-group">
                                    <label class="labelTitle">Rate (Rs)</label>
                                    <input type="number" class="form-control" id="purchase_price" placeholder="Enter Number Only">
                                    <span class="text-danger" id="buy-purchase_price"></span>
                                </div>
                                <div class="submitBtn">
                                    <button type="button" id="btn-buysharecalculator" class="btn btnSubmit">calculate</button>
                                </div>
                                <br>
                                <div id="buy_note" class="d-none">
                                    <table class="table table table-sm table-condensed table-hover">
                                        <tbody>
                                            <tr>
                                                <td><span class="sc-title">Total Amount</span></td><td><span class="sc-value pull-right" id='buy_total_amount'></span></td>
                                            </tr>
                                            <tr>
                                                <td><span class="sc-title">* Comission</span></td><td><span class="sc-value pull-right" id='buy_broker_commision'></span></td>
                                            </tr>
                                            <tr>
                                                <td><span class="sc-title">SEBON FEE</span></td><td><span class="sc-value pull-right" id='buy_sebon_fee'></span></td>
                                            </tr>
                                            <tr>
                                                <td><span class="sc-title">DP Charge</span></td><td><span class="sc-value pull-right" id='buy_dp_charge'></span></td>
                                            </tr>
                                            <tr class="purchase d-none">
                                                <td><span class="sc-title">Total Amount Payable (Rs)</span></td><td><span class="sc-value pull-right" id='buy_total_payable_amount'></span></td>
                                            </tr>
                                            <tr class="purchase d-none">
                                                <td><span class="sc-title">Cost Price Per Share (Rs)</span></td><td><span class="sc-value pull-right" id='buy_cost_price_per_unit'></span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <div class="clearfix"></div>
                                    <h3><strong>Note:</strong></h3>
                                    <p id="buy_comission_info"></p>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col* col-md-6 col-lg-6 sellBuyCalc">
                <div class="card">
                    <div class="card-body">
                        <h2 class="titleHead"><span>Sell Calculator</span></h2>
                        <div class="customForm">
                            <form>
                                <div class="form-group">
                                    <label class="labelTitle">Quantity</label>
                                    <input type="number" class="form-control" id="sell_share_qty" placeholder="Enter Number Only">
                                    <span class="text-danger" id="sell-share-qty"></span>
                                </div>
                                <div class="form-group">
                                    <label class="labelTitle">Purchase Rate (Rs)</label>
                                    <input type="number" class="form-control" id="sell_purchase_price" placeholder="Enter Number Only">
                                    <span class="text-danger" id="sell-purchase_price"></span>
                                </div>
                                <div class="form-group">
                                    <label class="labelTitle">Selling Rate (Rs)</label>
                                    <input type="number" class="form-control" id="selling_price" placeholder="Enter Number Only">
                                    <span class="text-danger" id="sell-selling_price"></span>
                                </div>
                                <div class="form-group">
                                    <label class="labelTitle">Investor Type</label>
                                    <select id="investor" class="form-control" name="investor">
                                        <option value="GI">Individual</option>
                                        <option value="II">Institutional</option>
                                    </select>
                                </div>
                                <div class="submitBtn">
                                    <button type="button" id="btn-sellsharecalculator" class="btn btnSubmit">calculate</button>
                                </div>
                                <br>
                                <div  id="sell_note" class="d-none">
                                    <table class="table table table-sm table-condensed table-hover">
                                        <tbody>
                                            <tr class="selling d-none">
                                                <td>Investor Type</td><td><span class="sc-value pull-right" id='sell_investor_type'></span></td>
                                            </tr>
                                            <tr>
                                                <td><span class="sc-title">Total Amount</span></td><td><span class="sc-value pull-right" id='sell_total_amount'></span></td>
                                            </tr>
                                            <tr>
                                                <td><span class="sc-title">* Comission</span></td><td><span class="sc-value pull-right" id='sell_broker_commision'></span></td>
                                            </tr>
                                            <tr>
                                                <td><span class="sc-title">SEBON FEE</span></td><td><span class="sc-value pull-right" id='sell_sebon_fee'></span></td>
                                            </tr>
                                            <tr>
                                                <td><span class="sc-title">DP Charge</span></td><td><span class="sc-value pull-right" id='sell_dp_charge'></span></td>
                                            </tr>
                                            <tr class="selling d-none">
                                                <td><span class="sc-title">Total Amount Receivable (Rs)</span></td><td><span class="sc-value pull-right" id='sell_total_receivable_amount'></span></td>
                                            </tr>
                                            <tr class="selling d-none">
                                                <td><span class="sc-title">Capital Gain Tax (5%) (Rs)</span></td><td><span class="sc-value pull-right" id='sell_capitaltax'></span></td>
                                            </tr>
                                            <tr class="selling profit_loss d-none">
                                                <td><span class="sc-title">Profit/Loss (Rs)</span></td><td><span class="sc-value pull-right" id='sell_net_profit_loss'></span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <div class="clearfix"></div>
                                    <h3><strong>Note:</strong></h3>
                                    <p id="sell_comission_info"></p>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<?php $count = 1; $totalcount = count($popupmessage)+1; ?>
@if(count($popupmessage)>0)
<div class="overlay-bg">
    @foreach($popupmessage as $kl => $item)
    <div class="overlay-content popup{{ $count++ }}">
        <h1>{{ $item->title }}</h1>
        <p><img src="{{ asset($item->image, $secure = null) }}" title="{{ $item->title }}" ></p>
        <button class="close-btn" id="{{ ($totalcount == $count)?'':$count }}" data-showpopup="{{ ($totalcount == $count)?'':$count }}">X</button>
    </div>
    @endforeach
</div>
@push('vi_script')
    <link href="{{ asset('site/js/overlay/overlay.min.css') }}" rel="stylesheet" type="text/css">
    <script type="text/javascript" src="{{ asset('site/js/overlay/overlay.min.js') }}"></script>
@endpush
@endif

@endsection