@extends('site/app')
@section('title', $page_header)
@section('keywords', $sitedetail->meta_keywords)
@section('description', $sitedetail->meta_descriptions)
@section('fb_image', $sitedetail->fb_image)
@section('main-content')
@section('breadcrumbs')
@section('breadcrumb_title', $page_header)
{{ Breadcrumbs::render('contact', $page_header) }}
@endsection
<section id="vcMainContent" class="mainContent">
          <div class="container">
            <div class="contactInfos">
              <div class="row">
                <div class="col* col-md-12 col-lg-8 contactLeft">
                  <div class="contactBox">
                    <div class="row no-gutters">
                      <div class="col* col-md-12 col-lg-6">
                        <div class="contactFlex">
                          <h6>Head Office</h6>
                          <div class="contactLink">
                            <ul>
                              <li>
                                <div class="contactIc">
                                  <i class="lni-map-marker"></i>
                                </div>
        
                                <div class="contactInfos">
                                  <span>{{ $sitedetail->address_en }}</span>
                                </div>
                              </li>
        
                              <li>
                                <div class="contactIc">
                                  <i class="lni-phone-handset"></i>
                                </div>
        
                                <div class="contactInfos">
                                  <span>{{ $sitedetail->phone_no }}</span>
                                </div>
                              </li>        
                              <li>
                                <div class="contactIc">
                                  <i class="lni-envelope"></i>
                                </div>
        
                                <div class="contactInfos">
                                  <span><a href="mailto:{{ $sitedetail->email }}">{{ $sitedetail->email }}</a></span>
                                </div>
                              </li>
                            </ul>
                          </div>
                        </div>

                        <div class="contactMap">
                          <iframe src="{{ $sitedetail->map }}"  frameborder="0" style="border:0" allowfullscreen></iframe>
                        </div>

                      </div>
					  	@if(!empty($socaildetail['branchlist']))
						@foreach($socaildetail['branchlist'] as $k => $item)
							<div class="col* col-md-12 col-lg-6">
								<div class="contactFlex">
									<h6>{{ $item->broker_name }}</h6>
									<div class="contactLink">
										<ul>
											<li>
											<div class="contactIc">
												<i class="lni-map-marker"></i>
											</div>
					
											<div class="contactInfos">
												<span>{{ $item->address }}</span>
											</div>
											</li>
					
											<li>
											<div class="contactIc">
												<i class="lni-phone-handset"></i>
											</div>
					
											<div class="contactInfos">
												<span>{{ $item->phone_no }}</span>
											</div>
											</li>
					
											<li>
											<div class="contactIc">
												<i class="lni-envelope"></i>
											</div>
					
											<div class="contactInfos">
												<span><a href="mailto:{{ $item->email_address }}">{{ $item->email_address }}</a></span>
											</div>
											</li>
										</ul>
									</div>
								</div>
		
								<div class="contactMap">
									<iframe src="{{ $item->map }}"  frameborder="0" style="border:0" allowfullscreen></iframe>
								</div>							
							</div>
						@endforeach
						@endif
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
@endsection     