<?php
$jsondata = getJsonData('marketinformationapi');
?>
<div class="table-responsive mt-10">
    <table class="table table-hover table-striped">
        <thead>
            <tr>
                <th>Index</th>
                <th>Current</th>
                <th colspan="3" class="text-right">Change</th>
            </tr>
        </thead>
        <tbody>
            @if(!empty($jsondata))
            @foreach($jsondata as $kl => $item)
            @if($item->issubindex == '1')
            <tr class=" text-white font-weight-bold {{ ($item->status == 'green') ? 'bg-success' : 'bg-danger' }}">
                <td>{{ $item->name }}</td>
                <td>{{ number_format($item->index_value, 2) }}</td>
                <td class="text-right">
                    {{ number_format($item->diff) }}
                    [{{ $item->per_change }}%]
                    <i class="lni lni-{{ ($item->per_change > 0) ? 'arrow-up' : 'arrow-down' }}"></i>
                </td>
            </tr>
            @endif
            @endforeach
            @endif
        </tbody>
    </table>
</div>