<?php
    $investment_data = getJsonData('investmentapi');
?>
<h2 class="titleHead"><span>Investment Opportunities</span></h2>
<?php
$inv_types = array_keys(get_object_vars($investment_data));
?>
<ul class="nav nav-tabs" id="myTab" role="tablist">
    @if(!empty($inv_types))
    @foreach($inv_types as $type)
    <li class="nav-item">
        <a class="nav-link @if($loop->first) active @endif" id="{{ str_replace(" ", "_", $type) }}-tab" data-toggle="tab" href="#{{ str_replace(" ", "_", $type) }}" role="tab" aria-controls="{{ str_replace(" ", "_", $type) }}" aria-selected="true">{{ $type }}</a>
    </li>
    @endforeach
    @endif
</ul>
<div class="tab-content" id="myTabContent">
    @if(!empty($investment_data))
    <?php $count = 0; ?>
    @foreach($investment_data as $k => $item)
    <div class="tab-pane fade show @if($loop->first) active @endif" id="{{ str_replace(" ", "_", $item[$count]->investment_type) }}" role="tabpanel" aria-labelledby="{{ str_replace(" ", "_", $item[$count]->investment_type) }}-tab">
        <table class="table table-hover table-striped">
            <thead>
                <tr>
                    <th>S.N.</th>
                    <th>Symbol</th>
                    <th>Company</th>
                    @if($item[$count]->investment_type == 'Right Share')
                    <th>Ratio</th>
                    @endif
                    <th>Units</th>
                    <th>Price</th>
                    <th>Opening Date</th>
                    <th>Closing Date</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @if(!empty($item))
                @foreach($item as $k => $inv_type_data)
                <tr>
                    <?php
                    $status_data =getInvestmentStatus($inv_type_data->opening_date, $inv_type_data->closing_date);
                    $status_title = $status_data['title'];
                    $status_style = $status_data['style'];
                    ?>
                    <td>{{ $k+1 }}</td>
                    <td>{{ $inv_type_data->symbol }}</td>
                    <td>{{ $inv_type_data->companyname }}</td>
                    @if($item[$count]->investment_type == 'Right Share')
                    <td>{{ $inv_type_data->ratio }}</td>
                    @endif
                    <td>{{ $inv_type_data->total_units }}</td>
                    <td>{{ $inv_type_data->price }}</td>
                    <td>{{ ($inv_type_data->opening_date) ? Carbon\Carbon::parse($inv_type_data->opening_date)->format('Y-m-d') : 'Coming Soon' }}</td>
                    <td>{{ ($inv_type_data->closing_date) ? Carbon\Carbon::parse($inv_type_data->closing_date)->format('Y-m-d') : 'Coming Soon' }}</td>
                    <td class="text-white {{ $status_style }}">{{ $status_title }}</td>
                </tr>
                @endforeach
                @endif
            </tbody>
        </table>
    </div>
    <? $count++ ?>
    @endforeach
    @endif
</div>
