@extends('site/app')
@section('title', $categorydetail->title)
@section('keywords', $sitedetail->meta_keywords)
@section('description', $sitedetail->meta_descriptions)
@section('fb_image', $sitedetail->fb_image)
@section('breadcrumbs')
@section('breadcrumb_title', $categorydetail->title)
{{ Breadcrumbs::render('list', $categorydetail) }}
@endsection
@section('main-content')
<section id="vcMainContent" class="mainContent">
	<div class="container">
		<div class="listingContent">
			<div class="row">
				@if(!empty($list))
				@foreach($list as $kl => $item)
				<div class="col* col-sm-6 col-md-4 col-lg-4 serviceList">
					<div class="listingFlexMain">
						@if($item->image != '')
						<figure>
							<img src="{{ asset($item->image, $secure = null) }}" alt="{{ $item->title }}">
						</figure>
						@endif
						
						<div class="listingFlexInfos">
							<h2>{{ str_limit($item->title,$limit = 110) }}</h2>
							<p>{!! str_limit(strip_tags($item->description), $limit = 150, $end = '...')  !!}</p>
							<a href="{{ route('post.detail',$item->slug) }}" class="readMore">Read More <span class="float-right">{{ $item->published_date }}</span></a>
						</div>
						
					</div>
				</div>
				@endforeach
				@endif
			</div>
			<div class="bottomPagination">
				{{ $list->links('vendor.pagination.bootstrap-4') }}
			</div>
		</div>
	</div>
</section>
@endsection