@extends('site/app')
@section('title', $page_header)
@section('keywords', $sitedetail->meta_keywords)
@section('description', $sitedetail->meta_descriptions)
@section('fb_image', $sitedetail->fb_image)

@section('breadcrumbs')
@section('breadcrumb_title', $page_header)
{{ Breadcrumbs::render('contact', $page_header) }}
@endsection

@section('main-content')
<section id="vc-common-page" class="common-page-sec">
	<div class="container">
		<div class="row">
			<div class="col* col-sm-8 col-md-8 left-cols">
				<div class="common-form">
					<form method="post" xclass="form-inline" id="share_calculator">
						{{ csrf_field() }}
						<div class="form-group">
							<label for="lbl_transactiontype"> Transaction Type</label>
							<select name="transaction_type" id="transaction_type" class="form-control bg-d">
								<option value="buy">Buy</option>
								<option value="sell">Sell</option>
							</select>
						</div>
						<div class="form-group">
							<label for="lbl_shareqty">Share Quantity</label>
							<input type="number" class="form-control" id="share_qty" name="share_qty" placeholder="Number Only">
						</div>
						<div class="form-group">
							<label for="lbl_purchase_price">Purchase Price (Rs)</label>
							<input type="number" class="form-control" id="purchase_price" name="purchase_price" placeholder="Number Only">
						</div>
						<div id="selling_row" style="display: none;" class="form-group">
							<label for="selling_price">Selling Price (Rs) </label>
							<input type="number" class="form-control" id="selling_price" name="selling_price" placeholder="Number Only">
						</div>
						<div id='investor_row' style="display: none;" class="form-group">
							<label for="lbl_investortype">Investor Type </label>
							<select name="investor" id="investor" class="form-control bg-d">
								<option value="GI">Individual</option>
								<option value="II">Institutional</option>
							</select>
						</div>
						<div class="form-group selling_row" style="display: none;" >
							<label class="form_title">Holding Period</label>
							<select id="holdingperiod" class="form-control" name="holdingperiod">
								<option value="5">More Than 1 year [5%]</option>
								<option value="7.5">Less Than 1 Year [7.5%]</option>
							</select>
						</div>
						<div class="form-group btn-group">
							<button type="button" id="calculate-btn" class="btn btn-success mr-3">Calculate</button>
							<button type="reset" class="btn btn-danger">Clear</button>
						</div>
					</form><!--form ends-->
					<div  id="note" style="display: none;">
						<table class="table table table-sm table-condensed table-hover">
							<tbody>
								<tr class="selling" style="display: none;">
									<td>Investor Type</td><td><span class="sc-value pull-right" id='investor_type'></span></td>
								</tr>
								<tr>
									<td><span class="sc-title">Total Amount</span></td><td><span class="sc-value pull-right" id='total_amount'></span></td>
								</tr>
								<tr>
									<td><span class="sc-title">* Comission</span></td><td><span class="sc-value pull-right" id='broker_commision'></span></td>
								</tr>
								<tr>
									<td><span class="sc-title">SEBON FEE</span></td><td><span class="sc-value pull-right" id='sebon_fee'></span></td>
								</tr>
								<tr>
									<td><span class="sc-title">DP Charge</span></td><td><span class="sc-value pull-right" id='dp_charge'></span></td>
								</tr>
								<tr class="purchase" style="display: none;">
									<td><span class="sc-title">Total Amount Payable (Rs)</span></td><td><span class="sc-value pull-right" id='total_payable_amount'></span></td>
								</tr>
								<tr class="selling" style="display: none;">
									<td><span class="sc-title">Total Amount Receivable (Rs)</span></td><td><span class="sc-value pull-right" id='total_receivable_amount'></span></td>
								</tr>
								<tr class="purchase" style="display: none;">
									<td><span class="sc-title">Cost Price Per Share (Rs)</span></td><td><span class="sc-value pull-right" id='cost_price_per_unit'></span></td>
								</tr>
								<tr class="selling" style="display: none;">
									<td><span class="sc-title">Capital Gain Tax (<span id="capitaltax_per"></span>%) (Rs)</span></td><td><span class="sc-value pull-right" id='capitaltax'></span></td>
								</tr>
								<tr class="selling profit_loss" style="display: none;">
									<td><span class="sc-title">Profit/Loss (Rs)</span></td><td><span class="sc-value pull-right" id='net_profit_loss'></span></td>
								</tr>
							</tbody>
						</table>
						<div class="clearfix"></div>
						<h3 class="text-org"><strong>Note:</strong></h3>
						<p class="text-org" id="comission_info"></p>
					</div>
				</div>
			</div>
			<div class="col* col-sm-4 col-md-4 right-cols">
				@include('site.sidebar.news')
				@include('site.sidebar.downloads')
			</div>
		</div>
	</div>
</section>
@endsection