@extends('site/app')
@section('title', $page_header)
@section('keywords', $sitedetail->meta_keywords)
@section('description', $sitedetail->meta_descriptions)
@section('fb_image', $sitedetail->fb_image)
@section('breadcrumbs')
{{ Breadcrumbs::render('contact', $page_header) }}
@endsection
@section('main-content')
<section class="teamCols">
	<div class="container">
		<div class="teamList">
			<h2 class="departmentTitle"><span>{{ $page_header }}</span></h2>
			<div class="row">
				@if(!empty($list))
					@foreach($list as $sl => $staff)
						<div class="col* col-sm-6 col-md-4 col-lg-3 teamListCol">
							<div class="our-team">
								@if($staff->image != '')
								<div class="pic">
									<img src="{{ url($staff->image) }}" class="img-responsive" alt="{{ $staff->name }}" title="{{ $staff->name }}">
								</div>
								@endif
								<div class="team-content">
									<h3 class="title">{{ $staff->name }}</h3>
									<span class="phnNumber">{{ $staff->phone_no }}</span>
									<span class="designationTeam">{{ $staff->position }}</span>
									<span class="mailTeam"><a href="mailto:{{ $staff->email }}">{{ $staff->email }}</a></span>
								</div>
							</div>
						</div>
					@endforeach
				@endif
			</div>
		</div>
	</div>
</section>
@endsection