@extends('admin/app')
@section('content')
<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">{{ $page_header }}</h3>
            <span class="pull-right"><a href="{{ route('staffdetail.create') }}" class="btn btn-warning"><i class="fa fa-plus" aria-hidden="true"></i>&nbsp; Add New </a></span>
        </div>
        <div class="box-body">
            <table class="table table-hover table-responsive table-condensed dataTablePagination compact">
                <thead class="bg-primary">
                    <tr>
                        <th>S.No</th>
                        <th>Branch</th>
                        <th>Department</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Email</th>
                        <th class="text-center">Sequence No</th>
                        <th class="text-center">Board Member</th>
                        <th class="text-center">Status</th>
                        <th class="text-center">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php // $count = ($list->currentpage()-1)*$list->perpage()+1; ?>
                    <?php $count = 1; ?>
                    @if(!empty($list))
                    @foreach ($list as $item)
                    <tr>
                        <td>{{ $count++ }}</td>
                        <td>{{ $item->broker_name }}</td>
                        <td>{{ $item->title }}</td>
                        {{-- <td>{{ $item->department->branch->broker_name }}</td> --}}
                        {{-- <td>{{ $item->department->title }}</td> --}}
                        <td>{{ $item->name }}</td>
                        <td>{{ $item->phone_no }}</td>
                        <td>{{ $item->email }}</td>
                        <td class="text-center">{{ $item->sequence_no }}</td>
                        <td class="text-center">{{ ($item->boardmember == '1')?'Yes':'-' }}</td>
                        <td class="text-center">
                            @if ($item->status == '1')
                            {!! ACTIVE_STATUS !!}
                            @else
                            {!! INACTIVE_STATUS !!}
                            @endif
                        </td>
                        <td class="text-center">
                            <a href="{{ route('staffdetail.edit', $item->id) }}"> {!! EDIT_ICON !!}</a>&nbsp;|
                            <a href="{{ route('staffdetail.delete', $item->id) }}" class="resetbtn">{!! DELETE_ICON !!} </a>
                        </td>
                    </tr>
                    @endforeach
                    @else
                    <tr>
                        <td colspan="5">{!! NO_RECORD !!}</td>
                    </tr>
                    @endif
                </tbody>
            </table>
            {{-- {{ $list->links() }} --}}
        </div>
    </div>
</div>
<div class="clearfix"></div>
@endsection