@extends('admin/app')
@section('content')
<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
    <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">{{ $page_header }}</h3>
          <span class="pull-right"><a href="{{ route('staffdetail.index') }}" class="btn btn-warning"><i class="fa fa-chevron-left" aria-hidden="true"></i>&nbsp;  View List </a></span>
        </div>
        <div class="box-body">
            <form class="" method="POST" action="{{ route('staffdetail.store') }}">
                {{ csrf_field() }}
                <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                    <div class="form-group">
                        <label for="department">Department <span class='text-danger'>*</span> </label>
                        <select name="department_id" id="department_id" class="form-control">
                            <option value="">Select Department</option>
                            @if(!empty($departmentlist))
                            @foreach($departmentlist as $kl => $item)
                                <option value="{{ $item->id }}">{{ $item->title.' ('. $item->branch->broker_name.' )' }}</option>
                            @endforeach
                            @endif
                        </select>
                        @if ($errors->has('department_id'))
                        <span class="help-block">
                            <strong>{{ $errors->first('department_id') }}</strong>
                        </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label class="control-label" for="name">Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" >
                        @if ($errors->has('name'))
                            <span class="help-block">
                                <strong>{{ $errors->first('name') }}</strong>
                            </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label class="control-label" for="phone_no">Phone No <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="phone_no" name="phone_no" value="{{ old('phone_no') }}" >
                        @if ($errors->has('phone_no'))
                            <span class="help-block">
                                <strong>{{ $errors->first('phone_no') }}</strong>
                            </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label class="control-label" for="email">Email <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="email" name="email" value="{{ old('email') }}" >
                        @if ($errors->has('email'))
                            <span class="help-block">
                                <strong>{{ $errors->first('email') }}</strong>
                            </span>
                        @endif
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label" for="position">Position <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="position" name="position" value="{{ old('position') }}" >
                                @if ($errors->has('position'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('position') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label" for="sequence_no">sequence No </label>
                                <input type="number" class="form-control" id="sequence_no" name="sequence_no" value="{{ old('sequence_no') }}" >
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label" for="position">Board Member <span class="text-danger">*</span></label>
                                <br>
                                <input type="radio" name="boardmember" value="1"> Yes 
                                <input type="radio" name="boardmember" value="0" checked style="margin-left: 5%"> No
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label" for="sequence_no">Board Member Position </label>
                                <input type="number" class="form-control" id="boardmember_position" name="boardmember_position" value="1">
                            </div>
                        </div>
                        <p><b>Note:</b> Sequence No will arrange the staff as per ascending number. Board Member Position & Squence no 1 will come in first position </p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">                    
                    <div class="form-group">
                        <?php if (!empty($record->image)) { ?>
                            <img src="<?php echo $record->image ?>" alt="" title="" class="img_box" id="prev_img" />
                        <?php } else { ?>
                            <img src="{{ asset('admin/images/no-image.png', $secure = null) }}" alt="" title="" class="img_box" id="prev_img" />
                        <?php } ?>
                        <a href="<?php echo url('/uploads/filemanager/dialog.php?type=1&field_id=image') ?>" data-fancybox-type="iframe" class="btn btn-info fancy">Insert</a>
                        <button class="btn btn-danger remove_box_image" type="button">Remove</button>
                        <button class="btn btn-warning prev_box_image" type="button" style="display: none;">Previous Image</button>
                        <input type="hidden" value="<?php echo isset($record->image)?$record->image:'' ?>"  name="image" class="form-control img_val" id="image">
                    </div>
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select name="status" id="statusid" class="form-control">
                            <option value="1">{!! PUBLISH !!}</option>
                            <option value="0">{!! UNPUBLISH !!}</option>
                        </select>
                    </div>
                   <div class="form-group">
                        <button type="submit" class="btn btn-success">Submit</button>
                        <button type="reset" class="btn btn-danger resetbtn">Clear</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="clearfix"></div>
@endsection