@extends('admin/app')
@section('content')
<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">{{ $page_header }}</h3>
            <span class="pull-right"><a href="{{ route('slider.create') }}" class="btn btn-warning"><i class="fa fa-plus" aria-hidden="true"></i>&nbsp; Add New </a></span>
        </div>
        <div class="box-body">
            <table class="table table-hover table-responsive table-condensed dataTable">
                <thead class="bg-primary">
                    <tr>
                        <th>S.No</th>
                        <th>Title</th>
                        <th>spokeperson</th>
                        <th class="text-center">Open Image</th>
                        <th class="text-center">Published Date</th>
                        <th class="text-center">Status</th>
                        <th class="text-center">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $count = ($list->currentpage()-1)*$list->perpage()+1; ?>
                    @if(!empty($list))
                    @foreach ($list as $item)
                    <tr>
                        <td>{{ $count++ }}</td>
                        <td>{{ str_limit($item->title, $limit = 50, $end = '...') }}</td>
                        <td>{{ $item->spokeperson }}</td>
                        <td class="text-center"><a href="{{ url($item->image) }}" target="_blank"><i class="fa fa-external-link" aria-hidden="true"></i></a></td>
                        <td class="text-center">{{ $item->published_date }}</td>
                        <td class="text-center">
                            @if ($item->status == '1')
                            {!! ACTIVE_STATUS !!}
                            @else
                            {!! INACTIVE_STATUS !!}
                            @endif
                        </td>
                        <td class="text-center">
                            <a href="{{ route('slider.edit', $item->id) }}"> {!! EDIT_ICON !!}</a>&nbsp;|
                            <a href="{{ route('slider.delete', $item->id) }}" class="resetbtn">{!! DELETE_ICON !!} </a>
                        </td>
                    </tr>
                    @endforeach
                    @else
                    <tr>
                        <td colspan="5">{!! NO_RECORD !!}</td>
                    </tr>
                    @endif
                </tbody>
            </table>
            {{ $list->links() }}
        </div>
    </div>
</div>
<div class="clearfix"></div>
@endsection