@extends('admin/app')
@section('content')
<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
    <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">{{ $page_header }}</h3>
          <span class="pull-right"><a href="{{ route('pages.index') }}" class="btn btn-warning"><i class="fa fa-chevron-left" aria-hidden="true"></i>&nbsp;  View List </a></span>
        </div>
        <div class="box-body">
            <form class="form-horizontal" method="POST" action="{{ route('pages.store') }}">
                {{ csrf_field() }}
                <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                    <div class="form-group">
                        <label class="control-label" for="title">Title <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="title" name="title" value="{{ old('title') }}" >
                        @if ($errors->has('title'))
                            <span class="help-block">
                                <strong>{{ $errors->first('title') }}</strong>
                            </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label class="control-label" for="description">Description <span class="text-danger">*</span></label>
                        <br>
                        <textarea id="my-editor" class="tinymce" name="description" placeholder="Place some text here" >{{ old('description') }}</textarea>
                        @if ($errors->has('description'))
                            <span class="help-block">
                                <strong>{{ $errors->first('description') }}</strong>
                            </span>
                        @endif
                    </div>
                </div>
                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="form-group">
                           <label class="control-label">Featured Image</label>
                            <?php if (!empty($record->image)) { ?>
                                <img src="<?php echo $record->image ?>" alt="" title="" class="img_box" id="prev_img" />
                            <?php } else { ?>
                                <img src="{{ asset('admin/images/no-image.png', $secure = null) }}" alt="" title="" class="img_box" id="prev_img" />
                            <?php } ?>
                            <a href="<?php echo url('/uploads/filemanager/dialog.php?type=1&field_id=image') ?>" data-fancybox-type="iframe" class="btn btn-info fancy">Insert</a>
                            <button class="btn btn-danger remove_box_image" type="button">Remove</button>
                            <button class="btn btn-warning prev_box_image" type="button" style="display: none;">Previous Image</button>
                            <input type="hidden" value="<?php echo isset($record->image)?$record->image:'' ?>"  name="image" class="form-control img_val" id="image">
                        </div>
                        <div class="form-group">
                            <label class="control-label" for="published_date">Published Date <span class="text-danger">*</span></label>
                            <input type="text" class="form-control datepicker" id="published_date" name="published_date" autocomplete="off" value="{{ date('Y-m-d') }}" >
                        </div>
                        <div class="form-group">
                            <label class="control-label" for="show_homepage">Show on HomePage <span class="text-danger">*</span></label>
                            <br>
                            <label class="radio-inline">
                                <input type="radio" name="show_homepage" value="1"> Yes 
                            </label>
                            <label class="radio-inline">
                                <input type="radio" name="show_homepage" value="0" checked> No
                            </label>
                        </div>
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select name="status" id="statusid" class="form-control">
                                <option value="1">{!! PUBLISH !!}</option>
                                <option value="0">{!! UNPUBLISH !!}</option>
                            </select>
                        </div>
                       <div class="form-group">
                            <button type="submit" class="btn btn-success">Submit</button>
                            <button type="reset" class="btn btn-danger resetbtn">Clear</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="clearfix"></div>
@endsection