@extends('admin/app')
@section('content')
<div class="box">
    <div class="box-header with-border">
        <h3 class="box-title">{{ $page_header }}</h3>
        <span class="pull-right"><a href="{{ route('downloads.create') }}" class="btn btn-warning"><i class="fa fa-plus" aria-hidden="true"></i>&nbsp; Add New </a></span>
    </div>
    <div class="box-body">
        <table class="table table-hover table-responsive table-condensed dataTable">
            <thead class="bg-primary">
                <tr>
                    <th>S.No</th>
                    <th>Category</th>
                    <th>Title</th>
                    <th class="text-center">Open File</th>
                    <th class="text-center">Published Date</th>
                    <th class="text-center">Status</th>
                    <th class="text-center">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $count = 1;?>
                @if(!empty($list))
                @foreach ($list as $item)
                <tr>
                    <td>{{ $count++ }}</td>
                    <td>{{ isset($item->categorydata->category_name)?$item->categorydata->category_name:'-' }}</td>
                    <td>{{ str_limit($item->title, $limit = 50, $end = '...') }}</td>
                    <td class="text-center"><a href="{{ url($item->file) }}" target="_blank"><i class="fa fa-external-link" aria-hidden="true"></i></a></td>
                    <td class="text-center">{{ $item->published_date }}</td>
                    <td class="text-center">
                        @if ($item->status == '1')
                        {!! ACTIVE_STATUS !!}
                        @else
                        {!! INACTIVE_STATUS !!}
                        @endif
                    </td>
                    <td class="text-center">
                        <a href="{{ route('downloads.edit', $item->id) }}"> {!! EDIT_ICON !!}</a>&nbsp;|
                        <a href="{{ route('downloads.delete', $item->id) }}" class="resetbtn">{!! DELETE_ICON !!} </a>
                    </td>
                </tr>
                @endforeach
                @else
                <tr>
                    <td colspan="5">{!! NO_RECORD !!}</td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
</div>
@endsection