@extends('admin/app')
@section('content')
<!-- Default box -->
<div class="col-md-8 col-lg-8 col-sm-12 col-xs-12">
    <div class="col-md-10 box">
        <div class="box-header with-border">
            <h3 class="box-title">{{ $page_header }}</h3>
        </div>
        <div class="box-body">
            <div class="table-responsive">
                <table class="table table-hover table-condensed dataTable">
                    <thead class="bg-primary">
                        <tr>
                            <th>S.No</th>
                            <th>Broker Branch</th>
                            <th>Title</th>
                            <th>Order</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1; ?>
                        @foreach ($list as $item)
                        <tr>
                            <td>{{ $count++ }}</td>
                            <td>{{ $item->branch->broker_name }}</td>
                            <td>{{ $item->sequence_no }}</td>
                            <td>{{ $item->title }}</td>
                            <td class="center-align">
                                @if ($item->status == '1')
                                {!! ACTIVE_STATUS !!}
                                @else
                                {!! INACTIVE_STATUS !!}
                                @endif
                            </td>
                            <td width="100px" class="center-align">
                                <a href="{{ route('department.edit', $item->id) }}">{!! EDIT_ICON !!} </a>&nbsp;|&nbsp;
                                <a href="{{ route('department.delete', $item->id) }}" class="resetbtn">{!! DELETE_ICON !!}</a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $list->links() }}
            </div>
        </div>
    </div>
</div>
<div class="col-md-4 col-lg-4 col-sm-12 col-xs-12">
    <div class="col-md-10 box">
        <div class="box-header with-border">
            <h3 class="box-title">Edit Department</h3>
            <span class="pull-right"><a href="{{ route('department.index') }}" class="btn btn-warning"><i class="fa fa-plus" aria-hidden="true"></i>&nbsp; Add New </a></span>
        </div>
        <div class="box-body">
            <form method="POST" action="{{ route('department.update', $record->id) }}">
                {{ csrf_field() }}
                {{ method_field('PATCH') }}
                <div class="form-group">
                    <label for="broekr">Broker Branch <span class='text-danger'>*</span> </label>
                    <select name="branch_id" id="branch_id" class="form-control">
                        <option value="">Select Broker Branch</option>
                        @if(!empty($brokerlist))
                        @foreach($brokerlist as $kl => $item)
                        <option value="{{ $item->id }}" @if($record->branch_id == $item->id) {{ 'selected' }} @endif>{{ $item->broker_name }}</option>
                        @endforeach
                        @endif
                    </select>
                    @if ($errors->has('branch_id'))
                    <span class="help-block">
                        <strong>{{ $errors->first('branch_id') }}</strong>
                    </span>
                    @endif
                </div>
                <div class="form-group">
                    <label for="title">Title <span class='text-danger'>*</span></label>
                    <input type="text" class="form-control" id="title" name="title" value="{{ $record->title }}">
                    @if ($errors->has('title'))
                    <span class="help-block">
                        <strong>{{ $errors->first('title') }}</strong>
                    </span>
                    @endif
                </div>
                <div class="form-group">
                    <label for="sequence_no">Sequence Number <span class='text-danger'>*</span></label>
                    <input type="text" class="form-control" id="sequence_no" name="sequence_no" value="{{ $record->sequence_no }}">
                </div>
                <div class="form-group">
                    <label for="status">Status</label>
                    <select name="status" id="statusid" class="form-control">
                        <option value="1" <?= isset($record->status) && ($record->status == '1')? 'selected' : '' ?> >{!! PUBLISH !!}</option>
                        <option value="0" <?= isset($record->status) && ($record->status == '0')? 'selected' : '' ?> >{!! UNPUBLISH !!}</option>
                    </select>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-success">Update</button>
                    <button type="reset" class="btn btn-danger resetbtn">Reset</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection