@extends('admin/app')
@section('content')
<div class="box">
    <div class="box-header with-border">
        <h3 class="box-title">{{ $page_header }}</h3>
    </div>
    <div class="box-body table-responsive">
        <table class="table table-hover table-responsive table-condensed dataTable">
            <thead class="bg-primary">
                <tr>
                    <th>S.No</th>
                    <th>For Branch</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Date</th>
                    <th class="text-center">Status</th>
                    <th class="text-center">View</th>
                    <th class="text-center">Delete</th>
                </tr>
            </thead>
            <tbody>
                <?php $count = ($list->currentpage()-1)*$list->perpage()+1; ?>
                @if(!empty($list))
                @foreach ($list as $item)
                <tr>
                    <td>{{ $count++ }}</td>
                    <td>{{ $item->broker_name }}</td>
                    <td>{{ $item->name }}</td>
                    <td>{{ $item->email }}</td>
                    <td>{{ $item->inserted_date }}</td>
                    <td class="text-center">
                        @if($item->viewed == '1')
                        <span class="label label-danger">SEEN</span>
                        @else
                        <span class="label label-success">NEW</span>
                        @endif
                        <td class="text-center">
                            <a href="{{ route('contact.edit', $item->id) }}"> {!! VIEW_ICON !!}</a>
                        </td>
                        <td class="text-center">
                            <a href="{{ route('contact.delete', $item->id) }}" class="resetbtn">{!! DELETE_ICON !!} </a>
                        </td>
                    </tr>
                    @endforeach
                    @else
                    <tr>
                        <td colspan="5">{!! NO_RECORD !!}</td>
                    </tr>
                    @endif
                </tbody>
            </table>
            {{ $list->links() }}
        </div>
    </div>
</div>
@endsection