@extends('admin/app')
@section('content')
<!-- Default box -->
<div class="row">
    <div class="col-md-8 col-lg-8 col-sm-12 col-xs-12">
        <div class="col-md-10 box">
            <div class="box-header with-border">
                <h3 class="box-title">{{ $page_header }}</h3>
            </div>
            <div class="box-body">
                <div class="table-responsive">
                    <table class="table table-hover table-condensed dataTable">
                        <thead class="bg-primary">
                            <tr>
                                <th>S.No</th>
                                <th>Broker Name</th>
                                <th>Sequence Number</th>
                                <th>Status</th>
                                <th class="text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $count = 1; ?>
                            @foreach ($list as $item)
                            <tr>
                                <td>{{ $count++ }}</td>
                                <td>{{ $item->broker_name }}</td>
                                <td>{{ $item->sequence_no }}</td>
                                <td class="text-center">
                                    @if ($item->status == '1')
                                    {!! ACTIVE_STATUS !!}
                                    @else
                                    {!! INACTIVE_STATUS !!}
                                    @endif
                                </td>
                                <td width="100px" class="text-center">
                                    <a href="{{ route($link.'.edit', $item->id) }}">{!! EDIT_ICON !!} </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    {{ $list->links() }}
                    <p><b>Note:</b> To Update Detail of Main Branch, Go To <a href="{{ route('setting') }}">Site Management Tab</a></p>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4 col-lg-4 col-sm-12 col-xs-12">
        <div class="col-md-10 box">
            <div class="box-header with-border">
                <h3 class="box-title">Edit Department</h3>
                <span class="pull-right"><a href="{{ route($link.'.index') }}" class="btn btn-warning"><i class="fa fa-plus" aria-hidden="true"></i>&nbsp; Add New </a></span>
            </div>
            <div class="box-body">
                <form method="POST" action="{{ route($link.'.update', $record->id) }}">
                    {{ csrf_field() }}
                    {{ method_field('PATCH') }}
                    <div class="form-group">
                        <label for="title">Branch Broker Name <span class='text-danger'>*</span></label>
                        <input type="text" class="form-control" id="broker_name" name="broker_name" value="{{ $record->broker_name }}">
                        @if ($errors->has('broker_name'))
                        <span class="help-block">
                            <strong>{{ $errors->first('broker_name') }}</strong>
                        </span>
                        @endif
                    </div>
                    @if($record->id != 1)
                    <div class="form-group">
                        <label for="sequence_no">Sequence Number </label>
                        <input type="text" class="form-control" id="sequence_no" name="sequence_no" value="{{ $record->sequence_no }}">
                    </div>
                    <div class="form-group">
                        <label for="title">Email Address </label>
                        <input type="text" class="form-control" id="email_address" name="email_address" value="{{ $record->email_address }}">
                        @if ($errors->has('email_address'))
                        <span class="help-block">
                            <strong>{{ $errors->first('email_address') }}</strong>
                        </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label for="title">Address </label>
                        <input type="text" class="form-control" id="address" name="address" value="{{ $record->address }}">
                        @if ($errors->has('address'))
                        <span class="help-block">
                            <strong>{{ $errors->first('address') }}</strong>
                        </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label for="title">Mobile No. </label>
                        <input type="text" class="form-control" id="mobile_no" name="mobile_no" value="{{ $record->mobile_no }}">
                        @if ($errors->has('mobile_no'))
                        <span class="help-block">
                            <strong>{{ $errors->first('mobile_no') }}</strong>
                        </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label for="title">Phone No </label>
                        <input type="text" class="form-control" id="phone_no" name="phone_no" value="{{ $record->phone_no }}">
                        @if ($errors->has('phone_no'))
                        <span class="help-block">
                            <strong>{{ $errors->first('phone_no') }}</strong>
                        </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label for="title">Fax No </label>
                        <input type="text" class="form-control" id="fax_no" name="fax_no" value="{{ $record->fax_no }}">
                        @if ($errors->has('fax_no'))
                        <span class="help-block">
                            <strong>{{ $errors->first('fax_no') }}</strong>
                        </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label for="title">Other Data Name</label>
                        <input type="text" class="form-control" id="other_data_name" name="other_data_name" value="{{ $record->other_data_name }}">
                        @if ($errors->has('other_data_name'))
                        <span class="help-block">
                            <strong>{{ $errors->first('other_data_name') }}</strong>
                        </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label for="title">Other Data Value</label>
                        <input type="text" class="form-control" id="other_data_value" name="other_data_value" value="{{ $record->other_data_value }}">
                        @if ($errors->has('other_data_value'))
                        <span class="help-block">
                            <strong>{{ $errors->first('other_data_value') }}</strong>
                        </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label for="title">Office Hours </label>
                        <input type="text" class="form-control" id="office_hour" name="office_hour" value="{{ $record->office_hour }}">
                        @if ($errors->has('office_hour'))
                        <span class="help-block">
                            <strong>{{ $errors->first('office_hour') }}</strong>
                        </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label for="title">Map </label>
                        <input type="text" class="form-control" id="map" name="map" value="{{ $record->map }}">
                        @if ($errors->has('map'))
                        <span class="help-block">
                            <strong>{{ $errors->first('map') }}</strong>
                        </span>
                        @endif
                    </div>
                    @endif
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select name="status" id="statusid" class="form-control">
                            <option value="1" <?= isset($record->status) && ($record->status == '1')? 'selected' : '' ?> >{!! PUBLISH !!}</option>
                            <option value="0" <?= isset($record->status) && ($record->status == '0')? 'selected' : '' ?> >{!! UNPUBLISH !!}</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="reset" class="btn btn-danger resetbtn">Reset</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection