$(function() {
    var baseurl = $('#baseurl').val();
    var nk = "https://nepsekhabar.com";
    
    // var newsharepricescrolldate = $('#newsharepricescrolldate').val();
    // var newsharepricescrolldata = $('#newsharepricescrolldata').val();
    var tempurl = $('#tempurl').val();
    var topgainerurl = $('#topgainerurl').val();

    $.ajax({
      url: tempurl,
    })
    .done(function(response) {
      $('#temp').html(response.main.temp+'<sup>℃</sup>');
    });

    $.ajax({
      url: nk+'/api/nepse-date.php',
    })
    .done(function(resp) {
      $('#nepsedate').html($(resp).html());
    });

    $.ajax({
      url: nk+'/api/nepse-live.php',
    })
    .done(function(resp) {
      $('#nepsedata').html($(resp).html());
    });

    $.ajax({
      url: topgainerurl,
    })
    .done(function (resp) {
      // console.log(resp);
      $('#topgainersection').html(resp);
    });

    $(".post-detail table").addClass("table table-sm table-hover table-striped");
    $(".post-detail img").addClass("img-responsive img-thumbnail");


    $('#btn-contactuspage').click(function(event) {
        var formdata = $("#frmcontactuspage").serialize();
        $("#statuspage-msg").removeClass('d-none');
        $("#statuspage-msg").html("");
        $("#branch_id-error").removeClass('d-none');
        $("#branch_id-error").html("");
        $("#name-error").removeClass('d-none');
        $("#name-error").html("");
        $("#email-error").removeClass('d-none');
        $("#email-error").html("");
        $("#address-error").removeClass('d-none');
        $("#address-error").html("")
        $("#phone_no-error").removeClass('d-none');
        $("#phone_no-error").html("");
        $("#message-error").removeClass('d-none');
        $("#message-error").html("");
        $.ajax({
            url: baseurl+'/insertfeedback',
            type: "POST",
            data: formdata
        }).always(function(resp) {
            if(resp.error=='true'){
                if(resp.errors.branch_id){
                  $('#branch_id-error').html(resp.errors.branch_id[0]);
                }
                if(resp.errors.name){
                  $('#name-error').html(resp.errors.name[0]);
                }
                if(resp.errors.email){
                  $('#email-error').html(resp.errors.email[0]);
                }
                if(resp.errors.address){
                  $('#address-error').html(resp.errors.address[0]);
                }
                if(resp.errors.phone_no){
                  $('#phone_no-error').html(resp.errors.phone_no[0]);
                }
                if(resp.errors.message){
                  $('#message-error').html(resp.errors.message[0]);
                }
            }
            if(resp.error=='false'){
                $("#frmcontactuspage")[0].reset();
                  $('#branch_id-error').addClass('d-none');
                  $('#name-error').addClass('d-none');
                  $('#email-error').addClass('d-none');
                  $('#address-error').addClass('d-none');
                  $('#phone_no-error').addClass('d-none');
                  $('#message-error').addClass('d-none');
                $("#statuspage-msg").removeClass('d-none');
                $("#statuspage-msg").html(resp.message);
            }
        });
    });

    startTime();

    $('#transaction_type').on('change', function() {
        var transaction = $('#transaction_type').val();
        if (transaction == "sell"){
            $('#selling_row').show();
            $('#investor_row').show();
            $('.selling_row').show();
        } else {
            $('#selling_row').hide();
            $('#investor_row').hide();
            $('.selling_row').hide();
        }
    });

    $("#investor").on("change", function() {
      "GI" == $("#investor").val() ? ($("#holdingperiod").html('<option value="5">More Than 1 year [5%]</option><option value="7.5">Less Than 1 Year [7.5%]</option>')) : ($("#holdingperiod").html('<option value="10">Institutional [10%]</option>'));
    });

    $('#calculate-btn').click(function(event) {
      var transaction_type = $('#transaction_type').val();
      var investor = $('#investor').val();
      var share_qty = parseInt($('#share_qty').val());
      var purchase_price = parseFloat($('#purchase_price').val());
      var selling_price = parseFloat($('#selling_price').val());
      var holdingperiod = parseFloat($('#holdingperiod').val());
      var totalPrice_buying = 0;
      var totalPrice_selling = 0;
      var dp_charge = 25;

      if(isNaN(purchase_price) || purchase_price <= 0){
        alert('Please Enter Price');
        return false;
      }
        totalPrice_buying  =  share_qty * purchase_price;
        var sebo_buy_amt =  0.00015 * totalPrice_buying;
        sebo_buy_amt = sebo_buy_amt.toFixed(2);
        var broker_buying = get_broker_commision(totalPrice_buying);
        var total_payable_amount = parseFloat(totalPrice_buying) +  parseFloat(sebo_buy_amt) + parseFloat(dp_charge) + parseFloat(broker_buying);
        var cost_price_per_unit = parseFloat(total_payable_amount/share_qty);
        cost_price_per_unit  = cost_price_per_unit.toFixed(2);
        total_payable_amount = total_payable_amount.toFixed(2);
        console.log(transaction_type);

      if(transaction_type =='buy') {

        var nepse_comission = broker_buying * 0.20;
        var seb_regularity_fee = broker_buying * 0.006;

        $('.purchase').show();
        $('.selling').hide();
        $('#note').show();
        $('#total_amount').html(totalPrice_buying);
        $('#sebon_fee').html(sebo_buy_amt);
        $('#dp_charge').html(dp_charge);
        $('#capitaltax').html(0);
        $('#broker_commision').html(broker_buying);
        $('#cost_price_per_unit').html(cost_price_per_unit);
        $('#total_payable_amount').html(total_payable_amount);
        $('#comission_info').html('<b>* Commission Amount</b> includes NEPSE Commission <b> Rs '+nepse_comission.toFixed(2)+' </b> & SEBON Regularity Fee <b> Rs '+seb_regularity_fee.toFixed(2)+'</b>');
      }

      if(transaction_type =='sell') {
        if(isNaN(selling_price) || selling_price<=0) {
          alert('Please enter price');
          return false;
        }
        costPrice = share_qty * cost_price_per_unit;
        var totalPrice_selling = share_qty * selling_price;
        var broker_selling = get_broker_commision(totalPrice_selling);
        var sebo_sell_amt = totalPrice_selling * 0.00015;
        var total_selling_price = totalPrice_selling - broker_selling - sebo_sell_amt;
        var pnl = total_selling_price - total_payable_amount ;
        var capitaltax = 0;
        if(pnl > 0) {
          if((investor == 'GI')) {
            capitaltax = pnl * (holdingperiod/100);
          }
          else {
            capitaltax = pnl * 0.1;
          }
        }
        else {
          capitaltax = 0;
        }

        total_receivable_amount = total_selling_price - capitaltax - dp_charge;
        capitaltax = capitaltax.toFixed(2);
        total_receivable_amount = total_receivable_amount.toFixed(2);

        var finalpl = total_receivable_amount - costPrice;
        var nepse_comission = broker_selling * 0.20;
        var seb_regularity_fee = broker_selling * 0.006;

        if((investor == 'GI')) {
            var investor_type = 'General Investor';
        } else {
          investor_type = 'Institutional Investor';
        }

        $('.purchase').hide();
        $('.selling').show();
        $('#note').show();
        $('#investor_type').html(investor_type);
        $('#total_amount').html(totalPrice_selling);
        $('#broker_commision').html(broker_selling);
        $('#sebon_fee').html(sebo_sell_amt.toFixed(2));
        $('#dp_charge').html(dp_charge);
        $('#capitaltax').html(capitaltax);
        $("#capitaltax_per").html(addCommas(holdingperiod));
        $('#total_receivable_amount').html(total_receivable_amount);
        $('#net_profit_loss').html(finalpl.toFixed(2));
        $('#comission_info').html('<b>* Commission Amount</b> includes NEPSE Commission <b> Rs '+nepse_comission.toFixed(2)+' </b> & SEBON Regularity Fee <b> Rs '+seb_regularity_fee.toFixed(2)+'</b>');
      }
    });

    $('#btn-buysharecalculator').click(function(event) {
      $('#buy-share-qty').html('');
      $('#buy-purchase_price').html('');
      var totalPrice_buying = 0;
      var dp_charge = 25;
      var share_qty = parseInt($('#buy_share_qty').val());
      var purchase_price = parseFloat($('#purchase_price').val());
      if(isNaN(share_qty) || share_qty <= 0){
        $('#buy-share-qty').html('Enter Share Quantity');
        return false;
      }
      if(isNaN(purchase_price) || purchase_price <= 0){
        $('#buy-purchase_price').html('Enter Purchase Price');
        return false;
      }
      totalPrice_buying  =  share_qty * purchase_price;
      var sebo_buy_amt =  0.00015 * totalPrice_buying;
      sebo_buy_amt = sebo_buy_amt.toFixed(2);
      var broker_buying = get_broker_commision(totalPrice_buying);
      var total_payable_amount = parseFloat(totalPrice_buying) +  parseFloat(sebo_buy_amt) + parseFloat(dp_charge) + parseFloat(broker_buying);
      var cost_price_per_unit = parseFloat(total_payable_amount/share_qty);
      cost_price_per_unit  = cost_price_per_unit.toFixed(2);
      total_payable_amount = total_payable_amount.toFixed(2);
      var nepse_comission = broker_buying * 0.20;
      var seb_regularity_fee = broker_buying * 0.006;

      $('.purchase').removeClass('d-none');
      $('#buy_note').removeClass('d-none');
      $('#buy_total_amount').html(totalPrice_buying);
      $('#buy_sebon_fee').html(sebo_buy_amt);
      $('#buy_dp_charge').html(dp_charge);
      $('#buy_capitaltax').html(0);
      $('#buy_broker_commision').html(broker_buying);
      $('#buy_cost_price_per_unit').html(cost_price_per_unit);
      $('#buy_total_payable_amount').html(total_payable_amount);
      $('#buy_comission_info').html('<b>* Commission Amount</b> includes NEPSE Commission <b> Rs '+nepse_comission.toFixed(2)+' </b> & SEBON Regularity Fee <b> Rs '+seb_regularity_fee.toFixed(2)+'</b>');
    });

    $('#btn-sellsharecalculator').click(function(event) {
      $('#sell-share-qty').html('');
      $('#sell-purchase_price').html('');
      $('#sell-selling_price').html('');
      var totalPrice_buying = 0;
      var totalPrice_selling = 0;
      var dp_charge = 25;
      var share_qty = parseInt($('#sell_share_qty').val());
      var purchase_price = parseFloat($('#sell_purchase_price').val());
      var selling_price = parseFloat($('#selling_price').val());
      var investor = $('#investor').val();
      if(isNaN(share_qty) || share_qty <= 0){
        $('#sell-share-qty').html('Enter Share Quantity');
        return false;
      }
      if(isNaN(purchase_price) || purchase_price <= 0){
        $('#sell-purchase_price').html('Enter Purchase Price');
        return false;
      }
      if(isNaN(selling_price) || selling_price <= 0){
        $('#sell-selling_price').html('Enter Selling Price');
        return false;
      }

      totalPrice_buying  =  share_qty * purchase_price;
      var sebo_buy_amt =  0.00015 * totalPrice_buying;
      sebo_buy_amt = sebo_buy_amt.toFixed(2);
      var broker_buying = get_broker_commision(totalPrice_buying);
      var total_payable_amount = parseFloat(totalPrice_buying) +  parseFloat(sebo_buy_amt) + parseFloat(dp_charge) + parseFloat(broker_buying);
      var cost_price_per_unit = parseFloat(total_payable_amount/share_qty);
      cost_price_per_unit  = cost_price_per_unit.toFixed(2);
      total_payable_amount = total_payable_amount.toFixed(2);

      costPrice = share_qty * cost_price_per_unit;
        var totalPrice_selling = share_qty * selling_price;
        var broker_selling = get_broker_commision(totalPrice_selling);
        var sebo_sell_amt = totalPrice_selling * 0.00015;
        var total_selling_price = totalPrice_selling - broker_selling - sebo_sell_amt;
        var pnl = total_selling_price - total_payable_amount ;
        var capitaltax = 0;
        if(pnl > 0) {
          if((investor == 'GI')) {
            capitaltax = pnl * 0.05;
          }
          else {
            capitaltax = pnl * 0.1;
          }
        }
        else {
          capitaltax = 0;
        }

        total_receivable_amount = total_selling_price - capitaltax - dp_charge;
        capitaltax = capitaltax.toFixed(2);
        total_receivable_amount = total_receivable_amount.toFixed(2);

        var finalpl = total_receivable_amount - costPrice;
        var nepse_comission = broker_selling * 0.20;
        var seb_regularity_fee = broker_selling * 0.006;

        if((investor == 'GI')) {
            var investor_type = 'General Investor';
        } else {
          investor_type = 'Institutional Investor';
        }

        $('.selling').removeClass('d-none');
        $('#sell_note').removeClass('d-none');
        $('#sell_investor_type').html(investor_type);
        $('#sell_total_amount').html(totalPrice_selling);
        $('#sell_broker_commision').html(broker_selling);
        $('#sell_sebon_fee').html(sebo_sell_amt.toFixed(2));
        $('#sell_dp_charge').html(dp_charge);
        $('#sell_capitaltax').html(capitaltax);
        $('#sell_total_receivable_amount').html(total_receivable_amount);
        $('#sell_net_profit_loss').html(finalpl.toFixed(2));
        $('#sell_comission_info').html('<b>* Commission Amount</b> includes NEPSE Commission <b> Rs '+nepse_comission.toFixed(2)+' </b> & SEBON Regularity Fee <b> Rs '+seb_regularity_fee.toFixed(2)+'</b>');

    });


});

function get_broker_commision(totalamount){
    var rate =  0;
    if(totalamount <= 50000) {
      rate = '0.40';
    }
    else if(totalamount>50000 && totalamount<=500000) {
      rate = '0.37';
    }
    else if(totalamount>500000 && totalamount<=2000000) {
      rate = '0.34';
    }
    else if(totalamount > 2000000 && totalamount < 10000000){
      rate = '0.30';
    }
    else if(totalamount>10000000){
      rate = '0.27';
    }
    var broker_commision = ((totalamount * rate)/100);
    return broker_commision.toFixed(2);
}

function addCommas(nStr){
  nStr += '';
  x = nStr.split('.');
  x1 = x[0];
  x2 = x.length > 1 ? '.' + x[1] : '';
  var rgx = /(\d+)(\d{3})/;
  while (rgx.test(x1)) {
      x1 = x1.replace(rgx, '$1' + ',' + '$2');
  }
  return x1 + x2;
}

function startTime() {
  const monthNames = ["January", "February", "March", "April", "May", "June",
    "July", "August", "September", "October", "November", "December"
  ];
    var today = new Date();
    var year = today.getFullYear();
    var month = monthNames[today.getMonth()];
    var date = checkTime(today.getDate());
    var hr = checkTime(today.getHours());
    var min = checkTime(today.getMinutes());
    var sec = checkTime(today.getSeconds());
    document.getElementById('datetime').innerHTML = year+'-'+month+'-'+date+', '+hr + ":" + min + ":" + sec;
    var t = setTimeout(startTime, 500);
}

function checkTime(i) {
    if (i < 10) {i = "0" + i};  // add zero in front of numbers < 10
    return i;
}