<?php

namespace App\Providers;

use App\Model\admin\AdminBrokerBranch;
use App\Model\admin\AdminSetting;
use App\Model\admin\AdminUser;
use App\Model\site\Home;
use Harimayco\Menu\Facades\Menu;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider {
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot() {
        Schema::defaultStringLength(191);
        view()->composer('site.*',function($view) {
            $sitedetail = AdminSetting::findorfail('1');
            $primarymenu = Menu::get(1);
            $topheadermenu = Menu::get(2);
            $rightsidemenu = Menu::get(3);
            $quicklinks = Menu::get(5);
            $meta_description = "Thirve Brokerage Company Pvt. Ltd";
            $title = "Thirve Brokerage Company Pvt. Ltd";
            $url = "http://thrivebrokerage.com";
            $branchlist = AdminBrokerBranch::where('id','!=','1')->where('status','1')->orderBy('sequence_no','asc')->get();
            $allbranchlist = AdminBrokerBranch::where('status','1')->orderBy('sequence_no','asc')->get();
            $notice = Home::getHomePostList($category='notice');
            $result = array(
                'branchlist'            => $branchlist,
                'allbranchlist'         => $allbranchlist,
                'noticelist'            => $notice,
            );

            $menulist = array(
                'primarymenu'           => $primarymenu,
                'topheadermenu'         => $topheadermenu,
                'rightsidemenu'         => $rightsidemenu,
                'quicklinks'            => $quicklinks,
            );

            $apilist = array(
                'sharepriceapi'         => 'https://nepsekhabar.com/api-data/todayshareprice',
                // 'newsapi'               => 'http://api-data.nepsekhabar.com/public/api/newslist',
                // 'marketinformationapi'  => 'http://api-data.nepsekhabar.com/public/api/nepseindices',
                // 'marketsummary'         => 'http://api-data.nepsekhabar.com/public/api/marketsummary',
                // 'sharepriceapi'         => 'http://nepsekhabar.com/api/api-data/todayshareprice',
                // 'iporesultapi'          => 'http://api-data.nepsekhabar.com/public/api/iporesult',
                'weatherapi'            => 'https://api.openweathermap.org/data/2.5/weather?q=kathmandu,np&appid=5269b43d2bd74f7d3c40a83d0d417790&units=metric',
            );
            $view->with('apilist', $apilist);
            $view->with('menulist', $menulist);
            $view->with('socaildetail', $result);
            $view->with('sitedetail', $sitedetail);
        });
        view()->composer('admin.*',function($view) {
            $sitedetail = AdminSetting::findorfail('1');
            $adminuserdetail = AdminUser::getAdminUserDetail();
            $view->with('sitedetail', $sitedetail);
            $view->with('adminuserdetail', $adminuserdetail);
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register(){
        //
        require_once __DIR__ . '/../Helper/printhelper.php';
    }
}
