<?php

namespace App\Model\site;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Staff extends Model {

    public static function getBrokerBranchList(){
        $data = DB::table('tbl_broker_branch')
                ->where('status','1')
                ->select('id','broker_name')
                ->orderBy('id','asc')
                ->get();
        return $data;
    }

    public static function getDepartmentList($branchid){
        $data = DB::table('tbl_department')
                ->where('branch_id',$branchid)
                ->where('status','1')
                ->select('id','title')
                ->orderBy('sequence_no','asc')
                ->get();
        return $data;
    }

    public static function getStaffDetailList($departmentid){
        $data = DB::table('tbl_staffdetail')
                ->where('department_id',$departmentid)
                ->where('status','1')
                ->select('name','phone_no','email','position','image')
                ->orderBy('sequence_no','asc')
                ->get();
        return $data;
    }

    public static function getBoardMember(){
        $data = DB::table('tbl_staffdetail')
                ->where('boardmember','1')
                ->where('status','1')
                ->select('name','phone_no','email','position','image')
                ->orderBy('sequence_no','asc')
                ->get();
        return $data;
    }
}