<?php

namespace App\Model\site;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Post extends Model {
	public static function getPostList($category){
		 $data = DB::table('tbl_posts AS P')
                ->join('tbl_post_category AS PC','PC.post_id','=','P.id')
                ->join('tbl_category AS C','C.id','=','PC.category_id')
                ->where('C.slug', $category)
                ->where('P.status', '1')
                ->select('P.title', 'P.published_date', 'P.description', 'P.image', 'P.slug', 'C.title as category_title')
                ->orderBy('P.published_date', 'DESC')
                ->paginate(10);
        return $data;
	}

	public static function getPostDetail($slug){
		 $data = DB::table('tbl_posts')
                ->where('slug', $slug)
                ->where('status', '1')
                ->first();
        return $data;
	}
    
}
