<?php

namespace App\Model\site;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Home extends Model {

    public static function getSliderData(){
        $data = DB::table('tbl_slider')
                ->where('status','1')
                ->select('title','image','spokeperson')
                ->orderBy('published_date','desc')
                ->get();

        return $data;
    }

    public static function getShowHomePage(){
         $data = DB::table('tbl_pages')
                ->where('show_homepage', '1')
                ->where('status', '1')
                ->select('title','slug','description','image')
                ->first();
        return $data;
    }

	public static function getHomePostListDescription($category,$limit =5){
		 $data = DB::table('tbl_posts AS P')
                ->join('tbl_post_category AS PC','PC.post_id','=','P.id')
                ->join('tbl_category AS C','C.id','=','PC.category_id')
                ->where('C.slug', $category)
                ->where('P.status', '1')
                ->select('P.title', 'P.published_date', 'P.description','P.slug', 'C.title as category_title')
                ->orderBy('P.published_date', 'DESC')
                ->limit($limit)
                ->get();
        return $data;
	}

    public static function getHomeDownloadList($limit){
         $data = DB::table('tbl_downloads')
                ->where('status', '1')
                ->select('title','published_date','file')
                ->orderBy('published_date','desc')
                ->limit($limit)
                ->get();
        return $data;
    }
    
    /* this line*/
   
    public static function getDownloadCategory(){
         $data = DB::table('tbl_download_category')
                ->where('status', '1')
                ->select('id','category_name')
                ->orderBy('sequence_no','asc')
                ->get();
        return $data;
    }
    
    public static function getDownloadList($categoryid){
         $data = DB::table('tbl_downloads')
                ->where('category_id', $categoryid)
                ->where('status', '1')
                ->select('title','published_date','file')
                ->orderBy('published_date','desc')
                ->get();
        return $data;
    }
   
    public static function getMessageFromMD(){
        $data = DB::table('tbl_message_from_md')
                ->where('status','1')
                ->select('slug','title','image','description')
                ->orderBy('ordering','asc')
                ->get();

        return $data;
    }

    public static function getHomePostList($category,$limit =5){
        $data = DB::table('tbl_posts AS P')
                ->join('tbl_post_category AS PC','PC.post_id','=','P.id')
                ->join('tbl_category AS C','C.id','=','PC.category_id')
                ->where('C.slug', $category)
                ->where('P.status', '1')
                ->select('P.title', 'P.published_date', 'P.slug', 'C.title as category_title')
                ->orderBy('P.published_date', 'DESC')
                ->limit($limit)
                ->get();
        return $data;
    }


    public static function getMessageDetail($slug){
         $data = DB::table('tbl_message_from_md')
                ->where('slug', $slug)
                ->where('status', '1')
                ->first();
        return $data;
    }

    public static function getPagesDetail($slug){
         $data = DB::table('tbl_pages')
                ->where('slug', $slug)
                ->where('status', '1')
                ->select('title','description','image','published_date')
                ->first();
        return $data;
    }


	public static function getCategoryList($slug){
        $data = DB::table('tbl_posts AS P')
                ->join('tbl_post_category AS PC','PC.post_id','=','P.id')
                ->join('tbl_category AS C','C.id','=','PC.category_id')
                ->where('C.slug', $slug)
                ->where('P.status', '1')
                ->select('P.title','P.published_date','P.image','P.description','P.slug','C.title as category_title')
                ->orderBy('P.published_date', 'DESC')
                ->paginate(PAGES);
        return $data;
	}

    public static function getCategoryName($slug){
        $data = DB::table('tbl_category')
                ->where('slug', $slug)
                ->where('status', '1')
                ->select('title')
                ->first();
        return $data;
    }

   

    public static function getCareerList(){
         $data = DB::table('tbl_career')
                ->where('status', '1')
                ->select('title','published_date','description')
                ->orderBy('published_date','desc')
                ->get();
        return $data;
    }

    public static function getSearch($tablename,$title){
         $data = DB::table($tablename)
                ->where('title', 'like', '%'.$title.'%')
                ->where('status', '1')
                ->select('title','slug','published_date')
                ->orderBy('title','asc')
                ->limit(15)
                ->get();
        return $data;
    }

    public static function getDownloadSearch($title){
         $data = DB::table('tbl_downloads')
                ->where('title', 'like', '%'.$title.'%')
                ->where('status', '1')
                ->select('title','file','published_date')
                ->orderBy('title','asc')
                ->limit(15)
                ->get();
        return $data;
    }

    public static function getPopupMessage(){
        $data = DB::table('tbl_popup')
                ->where('status', '1')
                ->select('title','link','image')
                ->orderBy('published_date','desc')
                ->get();
        return $data;
    }

   

}
