<?php

namespace App\Model\admin;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class AdminStaffDetail extends Model {

    protected $table = 'tbl_staffdetail';
    protected $guarded = ['id'];

   	public function department(){
   		return $this->belongsTo(AdminDepartment::Class, 'department_id');
    }


    public static function getStaffList(){
		$data = DB::table('tbl_staffdetail AS S')
                ->join('tbl_department AS D','D.id','=','S.department_id')
                ->join('tbl_broker_branch AS B','B.id','=','D.branch_id')
                ->where('S.status', '1')
                ->select('S.*', 'D.title', 'B.broker_name')
                ->orderBy('D.sequence_no', 'asc')
                ->get();
                // ->paginate(PAGES);
        return $data;
    }
}
