<?php

namespace App\model\admin;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class AdminContact extends Model {

    protected $table = 'tbl_feedback';
    protected $guarded = ['id'];
    public $timestamps = false;

    public static function getContactList(){
    	$data = DB::table('tbl_feedback AS F')
    			->join('tbl_broker_branch AS B','B.id','=','F.branch_id')
				->select('F.*','B.broker_name')
				->orderBy('F.inserted_date', 'desc')
				->paginate(PAGES);

		return $data;
    }
}
