<?php

namespace App\Http\Controllers\site;

use App\Http\Controllers\Controller;
use App\Model\site\Staff;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class StaffController extends Controller {

	public function staffList(){
        $branchlist = Staff::getBrokerBranchList();
        if (!empty($branchlist)) {
            foreach ($branchlist as $k => $val) {
                $departmentlist = Staff::getDepartmentList($val->id);
                if (!empty($departmentlist)) {
                    foreach ($departmentlist as $kl => $dep) {
                        $stafflist = Staff::getStaffDetailList($dep->id);
                        $departmentlist[$kl]->stafflist = $stafflist;
                    }
                }
                $branchlist[$k]->departmentlist = $departmentlist;
            }
        }
        // return $branchlist;
        $result = array(
            'list'              => $branchlist,
            'page_header'       => 'Management Team'
        );
        return view('site.staff', $result);
	}

    public function boardMember(){
        $list = Staff::getBoardMember();
        $result = array(
            'list'              => $list,
            'page_header'       => 'Board Members'
        );
        return view('site.boardmember', $result);
    }
}