<?php

namespace App\Http\Controllers\site;

use App\Http\Controllers\Controller;
use App\Model\site\Home;
use App\model\admin\AdminContact;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;

class HomeController extends Controller {

	public function index(){
        $sliderdata = Home::getSliderData();
        $showhomepage = Home::getShowHomePage();
        $downloadlist = Home::getHomeDownloadList($limit='5');
        $newsevent = Home::getHomePostListDescription($category='news-events');
        $popupmessage = Home::getPopupMessage();
        $result = array(
            'page_header'       => 'Home',
            'sliderdata'        => $sliderdata,
            'showhomepage'      => $showhomepage,
            'newsevent'         => $newsevent,
            'popupmessage'      => $popupmessage,
            'downloadlist'      => $downloadlist,
        );
        return view('site.home', $result);
    }

     public function messageDetail($slug){
        $detail = Home::getMessageDetail($slug);
        if (!empty($detail)) {
            $result = array(
                'detail'    => $detail,
            );
            return view('site.messagedetail', $result);
        } else{
            return view('errors.404');
        }
    }

    public function insertfeedback(Request $request){
        $validator = Validator::make($request->all(), [
            'branch_id'         => 'required',
            'name'              => 'required|min:2',
            'email'             => 'required|email',
            'phone_no'          => 'required',
            // 'address'           => 'required|min:5',
            'message'           => 'required|min:10',
        ]);

        if ($validator->passes()) {
            $contact = new AdminContact;
            $contact->branch_id = $request->branch_id;
            $contact->name = $request->name;
            $contact->email = $request->email;
            $contact->phone_no = $request->phone_no;
            $contact->address = null;//$request->address;
            $contact->ip_address = $request->ip();
            $contact->message = $request->message;
            $contact->inserted_date = date('Y-m-d H:i:s');
            $contact->viewed = '0';
            $contact->status = '1';
            $contact->save();
            // Store your user in database
            return Response::json(['error' => 'false', 'message' => "We've received your valuable feedback. Thank You !!!"]);
        }
        return Response::json(['error' => 'true','errors' => $validator->errors()]);
    }

    public function contactUs(){
        $result = array(
            'page_header'       => 'Contact Us',
        );
         return view('site.contact', $result);
    }

    public function pagesDetail($slug){
        $detail = Home::getPagesDetail($slug);
        if (!empty($detail)) {
            $result = array(
                'detail'    => $detail,
            );
            return view('site.pagedetail', $result);
        } else{
            return view('errors.404');
        }
    }

    public function downloadList(){
        $downloadlist = Home::getDownloadCategory();
        if (!empty($downloadlist)) {
            foreach ($downloadlist as $kl => $val) {
                $list = Home::getDownloadList($val->id);
                $downloadlist[$kl]->list = $list;
            }
        }
        $result = array(
            'downloadlist'      => $downloadlist,
            'page_header'       => 'Downloads'
        );
        return view('site.downloadlist', $result);
    }

    public function categoryList($slug){
        $categorydetail = Home::getCategoryName($slug);
        if (!empty($categorydetail)) {
            $list = Home::getCategoryList($slug);
            $result = array(
                'list'              => $list,
                'categorydetail'    => $categorydetail,
            );
            return view('site.categorylist', $result);
        } else{
            return view('errors.404');
        }
    }

    public function shareCalculator(){
        $result = array(
            'page_header'       => 'Share Calculator',
        );
        return view('site.calculator', $result);
    }

    public function nepsechartdata(){
        $urlx = 'http://nepalstock.com/graphdata/58/D';
        $cURLConnection = curl_init();

        curl_setopt($cURLConnection, CURLOPT_URL, $urlx);
        curl_setopt($cURLConnection, CURLOPT_RETURNTRANSFER, true);

        $datalist = curl_exec($cURLConnection);
        curl_close($cURLConnection);
        
        echo $datalist;

       // $jsonArrayResponse = json_decode($phoneList);

        //pe($jsonArrayResponse->content);
        
        //$nepseindex = @file_get_contents('http://nepalstock.com/graphdata/58/D');
        // $nepseindex = @file_get_contents('http://110.44.116.124:1521/lumenx/public/nepsechartdata');
        //echo $nepseindex;
    }

    public function career(){
        $list = Home::getCareerList();
        $result = array(
            'list'              => $list,
            'page_header'       => 'Career',
        );
        return view('site.career', $result);
    }

    public function iporesult(){
        $list = Home::getCareerList();
        $result = array(
            'list'              => $list,
            'page_header'       => 'IPO Result',
        );
        return view('site.iporesult', $result);
    }

    public function sharePriceScroll(){
        return view('site.components.scroll_price');
    }

    public function latestNewsScroll(){
        return view('site.components.latestnews');
    }

    public function marketInformation(){
        return view('site.components.marketinformation');
    }

    public function marketIndex(){
        return view('site.components.marketindex');
    }

    public function marketSubIndex(){
        return view('site.components.marketsubindex');
    }

    public function marketSummary(){
        return view('site.components.marketsummary');
    }

    public function investmentData(){
        return view('site.components.investment');
    }

    public function topGainer()
    {
        return view('site.components.topgainer');
    }

    public function searchBox(Request $request){
        if ($request['query'] != '') {
            $query = $request['query'];
            // posts
            $postlist = Home::getSearch('tbl_posts',$query);
            // download
            $downloadlist = Home::getDownloadSearch($query);
            // pages 
            $pagelist = Home::getSearch('tbl_pages',$query);
            $result = array(
                'postlist'      => $postlist,
                'pagelist'      => $pagelist,
                'downloadlist'  => $downloadlist,
                'query'         => $query,
                'page_header'   => 'Search',
            );
            return view('site.searchlist', $result);
        } else{
            $result = array(
                'query'         => '',
                'page_header'   => 'Search',
            );
            return view('site.searchlist', $result);
        }
    }

    public function paymentDetail(){
        $result = array(
            'page_header' => 'fonePay', 
        );
        return view('site.paymentdetail', $result);
    }


}
