<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\admin\AdminLoginController;
use App\Model\admin\AdminDepartment;
use App\Model\admin\AdminSetting;
use App\Model\admin\AdminStaffDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class AdminStaffDetailController extends Controller {

    private $title = 'Staff Detail';
    private $sort_by = 'name';
    private $sort_order = 'asc';
    private $index_link = 'staffdetail.index';
    private $list_page = 'admin.staffdetail.list';
    private $create_form = 'admin.staffdetail.add';
    private $update_form = 'admin.staffdetail.edit';
    private $link = 'staffdetail';

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = AdminStaffDetail::getStaffList();
        // $list = AdminStaffDetail::orderBy($this->sort_by, $this->sort_order)->paginate(PAGES);
        // pe($list);
        $result = array(
            'list'              => $list,
            'page_header'       => 'List of '.$this->title,
        );
        return view($this->list_page, $result);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $departmentlist = AdminDepartment::orderBy('title', $this->sort_order)->get();
        $result = array(
            'departmentlist'    => $departmentlist,
            'page_header'       => 'Add '.$this->title.' Detail',
        );
        return view($this->create_form, $result);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'department_id'     => 'required',
            'name'              => 'required',
        ]);
        $user_id = AdminLoginController::id();
        $crud = new AdminStaffDetail;
        $crud->department_id = $request->department_id;
        $crud->name = $request->name;
        $crud->phone_no = $request->phone_no;
        $crud->email = $request->email;
        $crud->position = $request->position;
        $crud->sequence_no = ($request->sequence_no != '')?$request->sequence_no:AdminSetting::nextSortOrder($table='tbl_staffdetail',$parameter='sequence_no');
        $crud->image = ($request->image != '')?chunkfullurl($request->image):null;
        $crud->boardmember = $request->boardmember;
        $crud->boardmember_position = ($request->boardmember_position != '')?$request->boardmember_position:'1';
        $crud->published_date = date('Y-m-d');
        $crud->status = $request->status;
        $crud->created_by = $user_id;
        $crud->save();
        Session::flash('success_message', CREATED);
        return redirect(route($this->index_link));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $record = AdminStaffDetail::findOrFail($id);
        $departmentlist = AdminDepartment::orderBy('title', $this->sort_order)->get();
        $result = array(
            'page_header'       => 'Edit '.$this->title.' Detail',
            'record'            => $record,
            'departmentlist'    => $departmentlist,
        );
        return view($this->update_form, $result);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'department_id'     => 'required',
            'name'              => 'required',
        ]);
        $user_id = AdminLoginController::id();
        $crud = AdminStaffDetail::findOrFail($id);
        $crud->department_id = $request->department_id;
        $crud->name = $request->name;
        $crud->phone_no = $request->phone_no;
        $crud->boardmember = $request->boardmember;
        $crud->boardmember_position = ($request->boardmember_position != '')?$request->boardmember_position:'1';
        $crud->email = $request->email;
        $crud->position = $request->position;
        $crud->sequence_no = ($request->sequence_no != '')?$request->sequence_no:AdminSetting::nextSortOrder($table='tbl_staffdetail',$parameter='sequence_no');
        $crud->image = ($request->image != '')?chunkfullurl($request->image):null;
        $crud->published_date = date('Y-m-d');
        $crud->updated_by = $user_id;
        $crud->status = $request->status;
        $crud->save();
        Session::flash('success_message', UPDATED);
        return redirect(route($this->index_link));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $crud = AdminStaffDetail::findOrFail($id);
        $crud->delete();
        Session::flash('success_message', DELETED);
        return redirect(route($this->index_link));
    }
}