<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\admin\AdminLoginController;
use App\Model\admin\AdminPosts;
use App\Model\admin\AdminCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class AdminPostsController extends Controller {

    private $title = 'Posts';
    private $sort_by = 'published_date';
    private $sort_order = 'desc';
    private $index_link = 'posts.index';
    private $list_page = 'admin.posts.list';
    private $create_form = 'admin.posts.add';
    private $update_form = 'admin.posts.edit';
    private $link = 'posts';

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = AdminPosts::select('id','title','slug','published_date','status')->orderBy($this->sort_by, $this->sort_order)->paginate(PAGES);
        $result = array(
            'list'              => $list,
            'page_header'       => 'List of '.$this->title,
        );
        return view($this->list_page, $result);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categorylist = AdminCategory::orderBy('title', 'asc')->get();
        $result = array(
            'categorylist'      => $categorylist,
            'page_header'       => 'Add '.$this->title.' Detail',
        );
        return view($this->create_form, $result);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'title'              => 'required',
            'description'        => 'required',
        ]);
        $user_id = AdminLoginController::id();
        $crud = new AdminPosts;
        $crud->title = $request->title;
        $crud->description = $request->description;
        if ($request->image != '') {
            $crud->image = chunkfullurl($request->image);
        }else {
            $crud->image = null;
        }
        $crud->published_date = $request->published_date;
        $crud->slug = str_slug($request->title, '-');
        $crud->created_by = $user_id;
        $crud->status = $request->status;
        $crud->save();
        $crud->category()->sync($request->category);
        Session::flash('success_message', CREATED);
        return redirect(route($this->index_link));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $categorylist = AdminCategory::orderBy('title', 'asc')->get();
        $record = AdminPosts::with('category')->where('id',$id)->first();
        $result = array(
            'page_header'       => 'Edit '.$this->title.' Detail',
            'record'            => $record,
            'categorylist'      => $categorylist,
        );
        return view($this->update_form, $result);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title'             => 'required',
            'slug'              => 'required',
            'description'       => 'required',
        ]);

        $user_id = AdminLoginController::id();
        $crud = AdminPosts::findOrFail($id);
        $crud->title = $request->title;
        $crud->description = $request->description;
        $crud->slug = str_slug($request->slug, '-');
        if ($request->image != '') {
            $crud->image = chunkfullurl($request->image);
        }else {
            $crud->image = null;
        }
        $crud->published_date = $request->published_date;
        $crud->updated_by = $user_id;
        $crud->status = $request->status;
        $crud->save();
        $crud->category()->sync($request->category);
        Session::flash('success_message', UPDATED);
        return redirect(route($this->index_link));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $crud = AdminPosts::findOrFail($id);
        $crud->delete();
        AdminPosts::deleteNewsCategoryList($id);
        Session::flash('success_message', DELETED);
        return redirect(route($this->index_link));
    }
}