<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\admin\AdminLoginController;
use App\Model\admin\AdminDownloads;
use App\Model\admin\AdminDownloadCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class AdminDownloadsController extends Controller {

    private $title = 'Downloads';
    private $sort_by = 'published_date';
    private $sort_order = 'desc';
    private $index_link = 'downloads.index';
    private $list_page = 'admin.downloads.list';
    private $create_form = 'admin.downloads.add';
    private $update_form = 'admin.downloads.edit';
    private $link = 'downloads';
    private $categorylist;

    public function __construct(){
        $this->categorylist = AdminDownloadCategory::all();
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = AdminDownloads::with('categorydata')->orderBy($this->sort_by, $this->sort_order)->get();
        $result = array(
            'list'              => $list,
            'page_header'       => 'List of '.$this->title,
        );
        return view($this->list_page, $result);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $result = array(
            'categorylist'      => $this->categorylist,
            'page_header'       => 'Add '.$this->title.' Detail',
        );
        return view($this->create_form, $result);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'category_id'   => 'required',
            'title'         => 'required',
            'file'          => 'required',
        ]);
        $user_id = AdminLoginController::id();
        $crud = new AdminDownloads;
        $crud->title = $request->title;
        $crud->category_id = $request->category_id;
        $crud->file = ($request->file != '')?chunkfullurl($request->file):null;
        $crud->published_date = $request->published_date;
        $crud->created_by = $user_id;
        $crud->status = $request->status;
        $crud->save();
        Session::flash('success_message', CREATED);
        return redirect(route($this->index_link));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $record = AdminDownloads::findOrFail($id);
        $result = array(
            'page_header'       => 'Edit '.$this->title.' Detail',
            'record'            => $record,
            'categorylist'      => $this->categorylist,
        );
        return view($this->update_form, $result);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'category_id'   => 'required',
            'title'         => 'required',
            'file'          => 'required',
        ]);

        $user_id = AdminLoginController::id();
        $crud = AdminDownloads::findOrFail($id);
        $crud->title = $request->title;
        $crud->category_id = $request->category_id;
        $crud->file = ($request->file != '')?chunkfullurl($request->file):null;
        $crud->published_date = $request->published_date;
        $crud->updated_by = $user_id;
        $crud->status = $request->status;
        $crud->save();
        Session::flash('success_message', UPDATED);
        return redirect(route($this->index_link));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $crud = AdminDownloads::findOrFail($id);
        $crud->delete();
        Session::flash('success_message', DELETED);
        return redirect(route($this->index_link));
    }
}