<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\admin\AdminLoginController;
use App\Model\admin\AdminBrokerBranch;
use App\Model\admin\AdminDepartment;
use App\Model\admin\AdminSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class AdminDepartmentController extends Controller {

    private $title = 'Department';
    private $sort_by = 'title';
    private $sort_order = 'asc';
    private $index_link = 'department.index';
    private $list_page = 'admin.department.list';
    private $create_form = 'admin.department.add';
    private $update_form = 'admin.department.edit';
    private $link = 'department';

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = AdminDepartment::orderBy($this->sort_by, $this->sort_order)->paginate(PAGES);
        $brokerlist = AdminBrokerBranch::orderBy('broker_name','asc')->get();
        $result = array(
            'list'              => $list,
            'brokerlist'        => $brokerlist,
            'page_header'       => 'List of '.$this->title,
    );
        return view($this->list_page, $result);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $result = array(
            'page_header'       => 'Add '.$this->title.' Detail',
        );
        return view($this->create_form, $result);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'branch_id'     => 'required',
            'title'         => 'required',
        ]);
        $user_id = AdminLoginController::id();
        $crud = new AdminDepartment;
        $crud->title = $request->title;
        $crud->branch_id = $request->branch_id;
        $crud->status = $request->status;
        $crud->sequence_no = ($request->sequence_no != '')?$request->sequence_no:AdminSetting::nextSortOrder('tbl_department','sequence_no');
        $crud->created_by = $user_id;
        $crud->save();
        Session::flash('success_message', CREATED);
        return redirect(route($this->index_link));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $record = AdminDepartment::findOrFail($id);
        $brokerlist = AdminBrokerBranch::orderBy('broker_name','asc')->get();
        $list = AdminDepartment::with('branch')->orderBy($this->sort_by, $this->sort_order)->paginate(PAGES);
        $result = array(
            'page_header'       => 'Edit '.$this->title.' Detail',
            'record'            => $record,
            'list'              => $list,
            'brokerlist'        => $brokerlist,
        );
        return view($this->update_form, $result);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title'         => 'required',
            'branch_id'     => 'required',
        ]);
        $user_id = AdminLoginController::id();
        $crud = AdminDepartment::findOrFail($id);
        $crud->title = $request->title;
        $crud->branch_id = $request->branch_id;
        $crud->updated_by = $user_id;
        $crud->sequence_no = ($request->sequence_no != '')?$request->sequence_no:AdminSetting::nextSortOrder('tbl_department','sequence_no');
        $crud->status = $request->status;
        $crud->save();
        Session::flash('success_message', UPDATED);
        return redirect(route($this->index_link));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $crud = AdminDepartment::findOrFail($id);
        $crud->delete();
        Session::flash('success_message', DELETED);
        return redirect(route($this->index_link));
    }
}