<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\admin\AdminLoginController;
use App\Model\admin\AdminBrokerBranch;
use App\Model\admin\AdminSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class AdminBrokerBranchController extends Controller {

    private $title = 'Broker Branch';
    private $sort_by = 'sequence_no';
    private $sort_order = 'asc';
    private $index_link = 'brokerbranch.index';
    private $list_page = 'admin.brokerbranch.list';
    private $create_form = 'admin.brokerbranch.add';
    private $update_form = 'admin.brokerbranch.edit';
    private $link = 'brokerbranch';

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = AdminBrokerBranch::orderBy($this->sort_by, $this->sort_order)->paginate(PAGES);
        $result = array(
            'list'              => $list,
            'page_header'       => 'List of '.$this->title,
            'link'              => $this->link,
        );
        return view($this->list_page, $result);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $result = array(
            'page_header'       => 'Add '.$this->title.' Detail',
            'link'              => $this->link,
        );
        return view($this->create_form, $result);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'broker_name'       => 'required',
        ]);
        $crud = new AdminBrokerBranch;
        $crud->broker_name = $request->broker_name;
        $crud->email_address = $request->email_address;
        $crud->address = $request->address;
        $crud->mobile_no = $request->mobile_no;
        $crud->phone_no = $request->phone_no;
        $crud->fax_no = $request->fax_no;
        $crud->other_data_name = $request->other_data_name;
        $crud->other_data_value = $request->other_data_value;
        $crud->office_hour = $request->office_hour;
        $crud->map = $request->map;
        $crud->status = $request->status;
        $crud->sequence_no = AdminSetting::nextSortOrder('tbl_broker_branch','sequence_no');
        $crud->save();
        Session::flash('success_message', CREATED);
        return redirect(route($this->index_link));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $record = AdminBrokerBranch::findOrFail($id);
        $list = AdminBrokerBranch::orderBy($this->sort_by, $this->sort_order)->paginate(PAGES);
        $result = array(
            'page_header'       => 'Edit '.$this->title.' Detail',
            'record'            => $record,
            'list'              => $list,
            'link'              => $this->link,
        );
        return view($this->update_form, $result);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'broker_name'         => 'required',
        ]);
        $crud = AdminBrokerBranch::findOrFail($id);
        $crud->broker_name = $request->broker_name;
        $crud->email_address = $request->email_address;
        $crud->address = $request->address;
        $crud->mobile_no = $request->mobile_no;
        $crud->phone_no = $request->phone_no;
        $crud->fax_no = $request->fax_no;
        $crud->other_data_name = $request->other_data_name;
        $crud->other_data_value = $request->other_data_value;
        $crud->office_hour = $request->office_hour;
        $crud->map = $request->map;
        $crud->status = $request->status;
        $crud->sequence_no = ($request->sequence_no != '')?$request->sequence_no:AdminSetting::nextSortOrder('tbl_broker_branch','sequence_no');
        $crud->save();
        Session::flash('success_message', UPDATED);
        return redirect(route($this->index_link));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        /*$crud = AdminBrokerBranch::findOrFail($id);
        $crud->delete();
        Session::flash('success_message', DELETED);*/
        return redirect(route($this->index_link));
    }
}